/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.util.ArrayList;
import java.util.List;
import org.febit.wit.util.StringUtil;

public class ClassNameBand {
    private final List<String> segment = new ArrayList<String>(12);
    private int arrayDepth = 0;

    public ClassNameBand(String string) {
        this.segment.add(string);
    }

    public ClassNameBand append(String string) {
        this.segment.add(string);
        return this;
    }

    public String pop() {
        return this.segment.remove(this.segment.size() - 1);
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public ClassNameBand plusArrayDepth() {
        ++this.arrayDepth;
        return this;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public boolean isSimpleName() {
        return this.segment.size() == 1;
    }

    public int size() {
        return this.segment.size();
    }

    public String getClassSimpleName() {
        if (this.segment.isEmpty()) {
            return null;
        }
        return this.segment.get(this.segment.size() - 1);
    }

    public String getClassPureName() {
        if (this.segment.isEmpty()) {
            return null;
        }
        return StringUtil.join(this.segment, '.');
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtil.join(this.segment, '.'));
        for (int i = 0; i < this.arrayDepth; ++i) {
            stringBuilder.append('[').append(']');
        }
        return stringBuilder.toString();
    }
}

