/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

public final class ClassMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private Entry<V>[] table;
    private int threshold;
    private int size;

    public ClassMap(int n) {
        int n2;
        if (n > 0x20000000) {
            n2 = 0x20000000;
        } else {
            for (n2 = 16; n2 < n; n2 <<= 1) {
            }
        }
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * 0.75f);
    }

    public ClassMap() {
        this(64);
    }

    public int size() {
        return this.size;
    }

    public V unsafeGet(Class<?> clazz) {
        Entry<V>[] entryArray = this.table;
        Entry<V> entry = entryArray[clazz.hashCode() & entryArray.length - 1];
        while (entry != null) {
            if (clazz == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Class<?> clazz) {
        ClassMap classMap = this;
        synchronized (classMap) {
            return this.unsafeGet(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize() {
        ClassMap classMap = this;
        synchronized (classMap) {
            if (this.size < this.threshold) {
                return;
            }
            Entry<V>[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = n << 1;
            if (n2 > 0x20000000) {
                if (this.threshold == 0x1FFFFFFF) {
                    throw new IllegalStateException("Capacity exhausted.");
                }
                this.threshold = 0x1FFFFFFF;
                return;
            }
            int n3 = n2 - 1;
            Entry[] entryArray2 = new Entry[n2];
            int n4 = n;
            while (n4-- > 0) {
                Entry<V> entry = entryArray[n4];
                while (entry != null) {
                    Entry<V> entry2 = entry;
                    entry = entry.next;
                    int n5 = entry2.id & n3;
                    entry2.next = entryArray2[n5];
                    entryArray2[n5] = entry2;
                }
            }
            this.threshold = (int)((float)n2 * 0.75f);
            this.table = entryArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(Class<?> clazz, V v) {
        ClassMap classMap = this;
        synchronized (classMap) {
            int n = clazz.hashCode();
            Entry<V>[] entryArray = this.table;
            int n2 = n & entryArray.length - 1;
            Entry<V> entry = entryArray[n2];
            while (entry != null) {
                if (clazz == entry.key) {
                    return entry.value;
                }
                entry = entry.next;
            }
            if (this.size >= this.threshold) {
                this.resize();
                entryArray = this.table;
                n2 = n & entryArray.length - 1;
            }
            entryArray[n2] = new Entry<V>(n, clazz, v, entryArray[n2]);
            ++this.size;
            return v;
        }
    }

    private static final class Entry<V> {
        final int id;
        final Class<?> key;
        V value;
        Entry<V> next;

        Entry(int n, Class<?> clazz, V v, Entry<V> entry) {
            this.value = v;
            this.id = n;
            this.key = clazz;
            this.next = entry;
        }
    }
}

