/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.febit.wit.Context;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.CollectionUtil;
import org.febit.wit.util.StringUtil;

public class ALU {
    private static final int OBJECT = 0x1FFFFFFF;
    private static final int STRING = 1023;
    private static final int CHAR = 511;
    private static final int BIG_DECIMAL = 255;
    private static final int BIG_INTEGER = 127;
    private static final int DOUBLE = 63;
    private static final int FLOAT = 31;
    private static final int LONG = 15;
    private static final int INTEGER = 7;
    private static final int SHORT = 3;
    private static final int BYTE = 1;
    private static final Class<?>[] KNOWN_BASE_IMMUTABLES = new Class[]{String.class, Integer.class, Long.class, Boolean.class, Short.class, Double.class, Float.class, Character.class, Byte.class, BigInteger.class, BigDecimal.class};

    private ALU() {
    }

    public static boolean isKnownBaseImmutable(Object object) {
        if (object == null) {
            return true;
        }
        return ALU.isKnownBaseImmutableType(object.getClass());
    }

    public static boolean isKnownBaseImmutableType(Class<?> clazz) {
        for (Class<?> clazz2 : KNOWN_BASE_IMMUTABLES) {
            if (!clazz2.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static int getTypeMark(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            return 1023;
        }
        if (clazz == Integer.class) {
            return 7;
        }
        if (clazz == Long.class) {
            return 15;
        }
        if (clazz == Short.class) {
            return 3;
        }
        if (clazz == Double.class) {
            return 63;
        }
        if (clazz == Float.class) {
            return 31;
        }
        if (clazz == Character.class) {
            return 511;
        }
        if (clazz == Byte.class) {
            return 1;
        }
        if (object instanceof Number) {
            if (object instanceof BigInteger) {
                return 127;
            }
            if (object instanceof BigDecimal) {
                return 255;
            }
            if (object instanceof AtomicInteger) {
                return 7;
            }
            if (object instanceof AtomicLong || object instanceof LongAdder || object instanceof LongAccumulator) {
                return 15;
            }
            if (object instanceof DoubleAdder) {
                return 63;
            }
            return 255;
        }
        return 0x1FFFFFFF;
    }

    private static int getTypeMark(Object object, Object object2) {
        ALU.requireNonNull(object, object2);
        return ALU.getTypeMark(object) | ALU.getTypeMark(object2);
    }

    public static Object plusOne(Object object) {
        ALU.requireNonNull(object);
        switch (ALU.getTypeMark(object)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() + 1;
            }
            case 511: {
                return ((Character)object).charValue() + '\u0001';
            }
            case 15: {
                return ((Number)object).longValue() + 1L;
            }
            case 63: {
                return ((Number)object).doubleValue() + 1.0;
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() + 1.0f);
            }
            case 127: {
                return ALU.toBigInteger(object).add(BigInteger.ONE);
            }
            case 255: {
                return ALU.toBigDecimal(object).add(BigDecimal.ONE);
            }
        }
        throw ALU.unsupportedTypeException(object);
    }

    public static Object minusOne(Object object) {
        ALU.requireNonNull(object);
        switch (ALU.getTypeMark(object)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() - 1;
            }
            case 511: {
                return ((Character)object).charValue() - '\u0001';
            }
            case 15: {
                return ((Number)object).longValue() - 1L;
            }
            case 63: {
                return ((Number)object).doubleValue() - 1.0;
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() - 1.0f);
            }
            case 127: {
                return ALU.toBigInteger(object).subtract(BigInteger.ONE);
            }
            case 255: {
                return ALU.toBigDecimal(object).subtract(BigDecimal.ONE);
            }
        }
        throw ALU.unsupportedTypeException(object);
    }

    public static Object plus(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object != null ? object : object2;
        }
        switch (ALU.getTypeMark(object, object2)) {
            case 1023: 
            case 0x1FFFFFFF: {
                return object.toString().concat(object2.toString());
            }
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() + ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() + ((Number)object2).longValue();
            }
            case 63: {
                return ((Number)object).doubleValue() + ((Number)object2).doubleValue();
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() + ((Number)object2).floatValue());
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).add(ALU.toBigInteger(object2));
                }
            }
            case 255: {
                return ALU.toBigDecimal(object).add(ALU.toBigDecimal(object2));
            }
            case 511: {
                return ALU.plus(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object minus(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() - ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() - ((Number)object2).longValue();
            }
            case 63: {
                return ((Number)object).doubleValue() - ((Number)object2).doubleValue();
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() - ((Number)object2).floatValue());
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).subtract(ALU.toBigInteger(object2));
                }
            }
            case 255: {
                return ALU.toBigDecimal(object).subtract(ALU.toBigDecimal(object2));
            }
            case 511: {
                return ALU.minus(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object negative(Object object) {
        ALU.requireNonNull(object);
        switch (ALU.getTypeMark(object)) {
            case 7: {
                return -((Integer)object).intValue();
            }
            case 15: {
                return -((Long)object).longValue();
            }
            case 63: {
                return -((Double)object).doubleValue();
            }
            case 31: {
                return Float.valueOf(-((Float)object).floatValue());
            }
            case 3: {
                return (int)(-((Short)object).shortValue());
            }
            case 127: {
                return ((BigInteger)object).negate();
            }
            case 255: {
                return ((BigDecimal)object).negate();
            }
            case 511: {
                return (int)(-((Character)object).charValue());
            }
        }
        throw ALU.unsupportedTypeException(object);
    }

    public static Object mult(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() * ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() * ((Number)object2).longValue();
            }
            case 63: {
                return ((Number)object).doubleValue() * ((Number)object2).doubleValue();
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() * ((Number)object2).floatValue());
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).multiply(ALU.toBigInteger(object2));
                }
            }
            case 255: {
                return ALU.toBigDecimal(object).multiply(ALU.toBigDecimal(object2));
            }
            case 511: {
                return ALU.mult(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object div(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() / ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() / ((Number)object2).longValue();
            }
            case 63: {
                return ((Number)object).doubleValue() / ((Number)object2).doubleValue();
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() / ((Number)object2).floatValue());
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).divide(ALU.toBigInteger(object2));
                }
            }
            case 255: {
                return ALU.toBigDecimal(object).divide(ALU.toBigDecimal(object2));
            }
            case 511: {
                return ALU.div(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object mod(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() % ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() % ((Number)object2).longValue();
            }
            case 63: {
                return ((Number)object).doubleValue() % ((Number)object2).doubleValue();
            }
            case 31: {
                return Float.valueOf(((Number)object).floatValue() % ((Number)object2).floatValue());
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).remainder(ALU.toBigInteger(object2));
                }
            }
            case 255: {
                return ALU.toBigDecimal(object).remainder(ALU.toBigDecimal(object2));
            }
            case 511: {
                return ALU.mod(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object and(Object object, Object object2) {
        return ALU.isTrue(object) ? object2 : object;
    }

    public static Object or(Object object, Object object2) {
        return ALU.isTrue(object) ? object : object2;
    }

    public static boolean not(Object object) {
        return !ALU.isTrue(object);
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() == ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() == ((Number)object2).longValue();
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).compareTo(ALU.toBigInteger(object2)) == 0;
                }
            }
            case 31: 
            case 63: 
            case 255: {
                return ALU.toBigDecimal(object).compareTo(ALU.toBigDecimal(object2)) == 0;
            }
            case 511: {
                return ALU.isEqual(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        return false;
    }

    public static boolean notEqual(Object object, Object object2) {
        return !ALU.isEqual(object, object2);
    }

    public static boolean greater(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() > ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() > ((Number)object2).longValue();
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).compareTo(ALU.toBigInteger(object2)) > 0;
                }
            }
            case 31: 
            case 63: 
            case 255: {
                return ALU.toBigDecimal(object).compareTo(ALU.toBigDecimal(object2)) > 0;
            }
            case 511: {
                return ALU.greater(ALU.charToInt(object), ALU.charToInt(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static boolean greaterEqual(Object object, Object object2) {
        return !ALU.less(object, object2);
    }

    public static boolean less(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 511: {
                return ALU.less(ALU.charToInt(object), ALU.charToInt(object2));
            }
            case 1: 
            case 3: 
            case 7: {
                return ((Number)object).intValue() < ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() < ((Number)object2).longValue();
            }
            case 127: {
                if (ALU.notDoubleOrFloat(object, object2)) {
                    return ALU.toBigInteger(object).compareTo(ALU.toBigInteger(object2)) < 0;
                }
            }
            case 31: 
            case 63: 
            case 255: {
                return ALU.toBigDecimal(object).compareTo(ALU.toBigDecimal(object2)) < 0;
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static boolean lessEqual(Object object, Object object2) {
        return !ALU.greater(object, object2);
    }

    public static Object bitAnd(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 511: {
                return ALU.bitAnd(ALU.charToInt(object), ALU.charToInt(object2));
            }
            case 1: {
                return ((Number)object).byteValue() & ((Number)object2).byteValue();
            }
            case 3: {
                return ((Number)object).shortValue() & ((Number)object2).shortValue();
            }
            case 7: {
                return ((Number)object).intValue() & ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() & ((Number)object2).longValue();
            }
            case 127: {
                if (!ALU.notDoubleOrFloat(object, object2)) break;
                return ALU.toBigInteger(object).and(ALU.toBigInteger(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object bitOr(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 511: {
                return ALU.bitOr(ALU.charToInt(object), ALU.charToInt(object2));
            }
            case 1: {
                return ((Number)object).byteValue() | ((Number)object2).byteValue();
            }
            case 3: {
                return ((Number)object).shortValue() | ((Number)object2).shortValue();
            }
            case 7: {
                return ((Number)object).intValue() | ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() | ((Number)object2).longValue();
            }
            case 127: {
                if (!ALU.notDoubleOrFloat(object, object2)) break;
                return ALU.toBigInteger(object).or(ALU.toBigInteger(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object bitXor(Object object, Object object2) {
        switch (ALU.getTypeMark(object, object2)) {
            case 511: {
                return ALU.bitXor(ALU.charToInt(object), ALU.charToInt(object2));
            }
            case 1: {
                return ((Number)object).byteValue() ^ ((Number)object2).byteValue();
            }
            case 3: {
                return ((Number)object).shortValue() ^ ((Number)object2).shortValue();
            }
            case 7: {
                return ((Number)object).intValue() ^ ((Number)object2).intValue();
            }
            case 15: {
                return ((Number)object).longValue() ^ ((Number)object2).longValue();
            }
            case 127: {
                if (!ALU.notDoubleOrFloat(object, object2)) break;
                return ALU.toBigInteger(object).xor(ALU.toBigInteger(object2));
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object bitNot(Object object) {
        ALU.requireNonNull(object);
        switch (ALU.getTypeMark(object)) {
            case 511: {
                return (int)(~((Character)object).charValue());
            }
            case 1: {
                return (int)(~((Byte)object).byteValue());
            }
            case 3: {
                return (int)(~((Short)object).shortValue());
            }
            case 7: {
                return ~((Integer)object).intValue();
            }
            case 15: {
                return (Long)object ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 127: {
                return ((BigInteger)object).not();
            }
        }
        throw ALU.unsupportedTypeException(object);
    }

    public static Object lshift(Object object, Object object2) {
        ALU.requireNonNull(object, object2);
        int n = ALU.requireNumber(object2).intValue();
        switch (ALU.getTypeMark(object)) {
            case 511: {
                return ((Character)object).charValue() << n;
            }
            case 1: {
                return (Byte)object << n;
            }
            case 3: {
                return (Short)object << n;
            }
            case 7: {
                return (Integer)object << n;
            }
            case 15: {
                return (Long)object << n;
            }
            case 127: {
                return ((BigInteger)object).shiftLeft(n);
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object rshift(Object object, Object object2) {
        ALU.requireNonNull(object, object2);
        int n = ALU.requireNumber(object2).intValue();
        switch (ALU.getTypeMark(object)) {
            case 511: {
                return ((Character)object).charValue() >> n;
            }
            case 1: {
                return (Byte)object >> n;
            }
            case 3: {
                return (Short)object >> n;
            }
            case 7: {
                return (Integer)object >> n;
            }
            case 15: {
                return (Long)object >> n;
            }
            case 127: {
                return ((BigInteger)object).shiftRight(n);
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    public static Object urshift(Object object, Object object2) {
        ALU.requireNonNull(object, object2);
        int n = ALU.requireNumber(object2).intValue();
        switch (ALU.getTypeMark(object)) {
            case 511: {
                return ((Character)object).charValue() >>> n;
            }
            case 1: {
                return (Byte)object >>> n;
            }
            case 3: {
                return (Short)object >>> n;
            }
            case 7: {
                return (Integer)object >>> n;
            }
            case 15: {
                return (Long)object >>> n;
            }
        }
        throw ALU.unsupportedTypeException(object, object2);
    }

    private static Object charToInt(Object object) {
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        return object;
    }

    private static boolean isSafeToLong(Class<?> clazz) {
        return clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class;
    }

    private static BigInteger toBigInteger(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (ALU.isSafeToLong(object.getClass())) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toBigInteger();
        }
        return new BigDecimal(object.toString()).toBigInteger();
    }

    private static BigDecimal toBigDecimal(Object object) {
        if (object == null) {
            return BigDecimal.ZERO;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (ALU.isSafeToLong(object.getClass())) {
            return BigDecimal.valueOf(((Number)object).longValue());
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        return new BigDecimal(object.toString());
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() == Boolean.class) {
            return (Boolean)object;
        }
        if (object == Context.VOID) {
            return false;
        }
        return CollectionUtil.notEmpty(object, true);
    }

    private static boolean notDoubleOrFloat(Object object) {
        Class<?> clazz = object.getClass();
        return clazz != Float.class && clazz != Double.class;
    }

    private static boolean notDoubleOrFloat(Object object, Object object2) {
        return ALU.notDoubleOrFloat(object) && ALU.notDoubleOrFloat(object2);
    }

    private static ScriptRuntimeException unsupportedTypeException(Object object, Object object2) {
        return new ScriptRuntimeException(StringUtil.format("Unsupported type: left[{}], right[{}]", object.getClass(), object2.getClass()));
    }

    private static ScriptRuntimeException unsupportedTypeException(Object object) {
        return new ScriptRuntimeException(StringUtil.format("Unsupported type: [{}]", object.getClass()));
    }

    public static Number requireNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        throw new ScriptRuntimeException("Number is required, not found: " + ClassUtil.getClassName(object));
    }

    private static void requireNonNull(Object object) {
        if (object == null) {
            throw new ScriptRuntimeException("value is null");
        }
    }

    private static void requireNonNull(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new ScriptRuntimeException(object != null ? "right value is null" : (object2 != null ? "left value is null" : "left & right values are null"));
        }
    }
}

