/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.resolvers.impl;

import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.Resolver;
import org.febit.wit.resolvers.ResolverManager;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.util.ALU;
import org.febit.wit.util.CollectionUtil;
import org.febit.wit.util.StringUtil;

public class PrimitiveArrayResolver
implements Resolver {
    public Class<?> getMatchClass() {
        return null;
    }

    @Override
    public void register(ResolverManager resolverManager) {
        resolverManager.registerResolver(boolean[].class, (blArray, n) -> blArray[n]);
        resolverManager.registerResolver(char[].class, (cArray, n) -> Character.valueOf(cArray[n]));
        resolverManager.registerResolver(int[].class, (nArray, n) -> nArray[n]);
        resolverManager.registerResolver(float[].class, (fArray, n) -> Float.valueOf(fArray[n]));
        resolverManager.registerResolver(double[].class, (dArray, n) -> dArray[n]);
        resolverManager.registerResolver(long[].class, (lArray, n) -> lArray[n]);
        resolverManager.registerResolver(short[].class, (sArray, n) -> sArray[n]);
        resolverManager.registerResolver(byte[].class, (byArray, n) -> byArray[n]);
        resolverManager.registerResolver(boolean[].class, (blArray, n, object) -> {
            blArray[n] = ALU.isTrue(object);
        });
        resolverManager.registerResolver(char[].class, (cArray, n, c) -> {
            cArray[n] = c.charValue();
        });
        resolverManager.registerResolver(int[].class, (nArray, n, number) -> {
            nArray[n] = number.intValue();
        });
        resolverManager.registerResolver(float[].class, (fArray, n, number) -> {
            fArray[n] = number.floatValue();
        });
        resolverManager.registerResolver(double[].class, (dArray, n, number) -> {
            dArray[n] = number.doubleValue();
        });
        resolverManager.registerResolver(long[].class, (lArray, n, number) -> {
            lArray[n] = number.longValue();
        });
        resolverManager.registerResolver(short[].class, (sArray, n, number) -> {
            sArray[n] = number.shortValue();
        });
        resolverManager.registerResolver(byte[].class, (byArray, n, number) -> {
            byArray[n] = number.byteValue();
        });
    }

    @FunctionalInterface
    protected static interface InternalSetResolver<T, C>
    extends SetResolver<T> {
        public void setValue(T var1, int var2, C var3);

        @Override
        default public void set(T t, Object object, Object object2) {
            if (object instanceof Number) {
                try {
                    this.setValue(t, ((Number)object).intValue(), object2);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ScriptRuntimeException(StringUtil.format("Array index out of bounds, index={}", object), arrayIndexOutOfBoundsException);
                }
                catch (ClassCastException classCastException) {
                    throw new ScriptRuntimeException(classCastException.getMessage(), classCastException);
                }
            }
            throw new ScriptRuntimeException(StringUtil.format("Invalid property or can't write: array#{}", object));
        }

        @Override
        default public Class<T> getMatchClass() {
            return null;
        }
    }

    @FunctionalInterface
    protected static interface InternalGetResolver<T>
    extends GetResolver<T> {
        public Object getValue(T var1, int var2);

        @Override
        default public Object get(T t, Object object) {
            if (object instanceof Number) {
                return this.getValue(t, ((Number)object).intValue());
            }
            switch (object.toString()) {
                case "size": 
                case "length": {
                    return CollectionUtil.getSize(t);
                }
                case "isEmpty": {
                    return CollectionUtil.getSize(t) == 0;
                }
            }
            throw new ScriptRuntimeException(StringUtil.format("Invalid property: array#{}", object));
        }

        @Override
        default public Class<T> getMatchClass() {
            return null;
        }
    }
}

