/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.resolvers.impl;

import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.util.StringUtil;

public class ObjectArrayResolver
implements GetResolver<Object[]>,
SetResolver<Object[]> {
    @Override
    public Object get(Object[] objectArray, Object object) {
        if (object instanceof Number) {
            return objectArray[((Number)object).intValue()];
        }
        switch (object.toString()) {
            case "size": 
            case "length": {
                return objectArray.length;
            }
            case "isEmpty": {
                return objectArray.length == 0;
            }
        }
        throw new ScriptRuntimeException(StringUtil.format("Invalid property: array#{}", object));
    }

    @Override
    public void set(Object[] objectArray, Object object, Object object2) {
        if (object instanceof Number) {
            try {
                objectArray[((Number)object).intValue()] = object2;
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ScriptRuntimeException(StringUtil.format("Array index out of bounds, index={}", object), arrayIndexOutOfBoundsException);
            }
        }
        throw new ScriptRuntimeException(StringUtil.format("Invalid property: array#{}", object));
    }

    @Override
    public Class<Object[]> getMatchClass() {
        return Object[].class;
    }
}

