/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.resolvers.impl;

import java.util.Collection;
import java.util.List;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.util.StringUtil;

public class CollectionResolver
implements GetResolver<Collection>,
SetResolver<Collection> {
    @Override
    public Class<Collection> getMatchClass() {
        return Collection.class;
    }

    @Override
    public Object get(Collection collection, Object object) {
        if (object instanceof Number && collection instanceof List) {
            try {
                return ((List)collection).get(((Number)object).intValue());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ScriptRuntimeException(StringUtil.format("index out of bounds:{}", object), indexOutOfBoundsException);
            }
        }
        switch (object.toString()) {
            case "size": 
            case "length": {
                return collection.size();
            }
            case "isEmpty": {
                return collection.isEmpty();
            }
        }
        throw new ScriptRuntimeException(StringUtil.format("Invalid property or can't read: java.util.Collection#{}", object));
    }

    @Override
    public void set(Collection collection, Object object, Object object2) {
        if (object instanceof Number) {
            int n;
            int n2 = ((Number)object).intValue();
            if (n2 >= (n = collection.size())) {
                for (int i = n2 - n; i != 0; --i) {
                    collection.add(null);
                }
                collection.add(object2);
                return;
            }
            if (collection instanceof List) {
                ((List)collection).set(n2, object2);
                return;
            }
        }
        throw new ScriptRuntimeException(StringUtil.format("Invalid property or can't write: java.util.Collection#{}", object));
    }
}

