/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.resolvers;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.febit.wit.Init;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.loggers.Logger;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.OutResolver;
import org.febit.wit.resolvers.Resolver;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.resolvers.impl.CommonResolver;
import org.febit.wit.util.ClassMap;

public class ResolverManager {
    protected Logger logger;
    protected boolean ignoreNullPointer = true;
    protected Resolver[] resolvers;
    public final ClassMap<GetResolver> getters = new ClassMap();
    public final ClassMap<SetResolver> setters = new ClassMap();
    public final ClassMap<OutResolver> outters = new ClassMap();
    protected final ArrayList<GetResolver> getResolvers = new ArrayList();
    protected final ArrayList<SetResolver> setResolvers = new ArrayList();
    protected final ArrayList<OutResolver> outResolvers = new ArrayList();
    protected final ArrayList<Class> getResolverTypes = new ArrayList();
    protected final ArrayList<Class> setResolverTypes = new ArrayList();
    protected final ArrayList<Class> outResolverTypes = new ArrayList();
    protected final CommonResolver commonResolver = new CommonResolver();

    protected static int lookup(ArrayList<Class> arrayList, Class<?> clazz) {
        int n = arrayList.size();
        while (n > 0) {
            if (!arrayList.get(--n).isAssignableFrom(clazz)) continue;
            return n;
        }
        return -1;
    }

    protected GetResolver resolveGetResolverIfAbsent(Class<?> clazz) {
        GetResolver getResolver = this.getters.get(clazz);
        if (getResolver != null) {
            return getResolver;
        }
        int n = ResolverManager.lookup(this.getResolverTypes, clazz);
        getResolver = n >= 0 ? this.getResolvers.get(n) : this.resolveGetResolver(clazz);
        return this.getters.putIfAbsent(clazz, getResolver);
    }

    protected GetResolver resolveGetResolver(Class<?> clazz) {
        return this.commonResolver;
    }

    protected SetResolver resolveSetResolverIfAbsent(Class<?> clazz) {
        SetResolver setResolver = this.setters.get(clazz);
        if (setResolver != null) {
            return setResolver;
        }
        int n = ResolverManager.lookup(this.setResolverTypes, clazz);
        setResolver = n >= 0 ? this.setResolvers.get(n) : this.resolveSetResolver(clazz);
        return this.setters.putIfAbsent(clazz, setResolver);
    }

    protected SetResolver resolveSetResolver(Class<?> clazz) {
        return this.commonResolver;
    }

    public OutResolver resolveOutResolver(Class<?> clazz) {
        OutResolver outResolver = this.outters.get(clazz);
        if (outResolver != null) {
            return outResolver;
        }
        int n = ResolverManager.lookup(this.outResolverTypes, clazz);
        outResolver = n >= 0 ? this.outResolvers.get(n) : this.commonResolver;
        return this.outters.putIfAbsent(clazz, outResolver);
    }

    @Init
    public void init() {
        if (this.resolvers != null) {
            for (Resolver resolver : this.resolvers) {
                resolver.register(this);
            }
            this.getResolvers.trimToSize();
            this.setResolvers.trimToSize();
            this.outResolvers.trimToSize();
            this.getResolverTypes.trimToSize();
            this.setResolverTypes.trimToSize();
            this.outResolverTypes.trimToSize();
        }
    }

    public void registerResolver(Class<?> clazz, Resolver resolver) {
        boolean bl;
        if (clazz == null) {
            return;
        }
        int n = clazz.getModifiers();
        boolean bl2 = !Modifier.isAbstract(n) || clazz.isArray();
        boolean bl3 = bl = !Modifier.isFinal(n) || Object[].class.isAssignableFrom(clazz);
        if (resolver instanceof GetResolver) {
            if (bl) {
                this.getResolverTypes.add(clazz);
                this.getResolvers.add((GetResolver)resolver);
            }
            if (bl2) {
                this.getters.putIfAbsent(clazz, (GetResolver)resolver);
            }
        }
        if (resolver instanceof SetResolver) {
            if (bl) {
                this.setResolverTypes.add(clazz);
                this.setResolvers.add((SetResolver)resolver);
            }
            if (bl2) {
                this.setters.putIfAbsent(clazz, (SetResolver)resolver);
            }
        }
        if (resolver instanceof OutResolver) {
            if (bl) {
                this.outResolverTypes.add(clazz);
                this.outResolvers.add((OutResolver)resolver);
            }
            if (bl2) {
                this.outters.putIfAbsent(clazz, (OutResolver)resolver);
            }
        }
    }

    public final Object get(Object object, Object object2) {
        if (object != null) {
            return this.resolveGetResolverIfAbsent(object.getClass()).get(object, object2);
        }
        return this.handleNullPointer();
    }

    public final void set(Object object, Object object2, Object object3) {
        if (object != null) {
            this.resolveSetResolverIfAbsent(object.getClass()).set(object, object2, object3);
            return;
        }
        this.handleNullPointer();
    }

    protected final Object handleNullPointer() {
        if (this.ignoreNullPointer) {
            return null;
        }
        throw new ScriptRuntimeException("Null pointer.");
    }
}

