/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loggers.impl;

import java.io.PrintStream;
import java.util.Locale;
import org.febit.wit.Init;
import org.febit.wit.loggers.AbstractLogger;

public class SimpleLogger
extends AbstractLogger {
    private static final PrintStream OUT = System.out;
    protected String level = "info";
    private String prefix;
    private int levelNum;

    @Init
    public void init() {
        this.prefix = '[' + this.name + "] ";
        switch (this.level.trim().toLowerCase(Locale.US)) {
            case "error": {
                this.levelNum = 4;
                break;
            }
            case "warn": {
                this.levelNum = 3;
                break;
            }
            case "info": {
                this.levelNum = 2;
                break;
            }
            case "debug": {
                this.levelNum = 1;
                break;
            }
            default: {
                this.levelNum = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    protected boolean isEnabled(int n) {
        return n >= this.levelNum;
    }

    @Override
    protected void log(int n, String string) {
        this.printLog(n, string, null);
    }

    @Override
    protected void log(int n, String string, Throwable throwable) {
        this.printLog(n, string, throwable);
    }

    private void printLog(int n, String string, Throwable throwable) {
        if (!this.isEnabled(n)) {
            return;
        }
        OUT.println(this.prefix.concat(string != null ? string : ""));
        if (throwable != null) {
            throwable.printStackTrace(OUT);
        }
    }
}

