/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loggers;

import org.febit.wit.loggers.Logger;
import org.febit.wit.util.StringUtil;

public abstract class AbstractLogger
implements Logger {
    protected static final int LEVEL_DEBUG = 1;
    protected static final int LEVEL_INFO = 2;
    protected static final int LEVEL_WARN = 3;
    protected static final int LEVEL_ERROR = 4;
    protected static final int LEVEL_OFF = 5;
    protected String name = "wit";

    protected abstract boolean isEnabled(int var1);

    protected abstract void log(int var1, String var2);

    protected abstract void log(int var1, String var2, Throwable var3);

    protected void log(int n, String string, Object ... objectArray) {
        if (this.isEnabled(n)) {
            this.log(n, StringUtil.format(string, objectArray));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(1);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(3);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(4);
    }

    @Override
    public void debug(String string) {
        this.log(1, string);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        this.log(1, string, objectArray);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    @Override
    public void info(String string) {
        this.log(2, string);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        this.log(2, string, objectArray);
    }

    @Override
    public void info(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }

    @Override
    public void warn(String string) {
        this.log(3, string);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        this.log(3, string, objectArray);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    @Override
    public void error(String string) {
        this.log(4, string);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        this.log(4, string, objectArray);
    }

    @Override
    public void error(String string, Throwable throwable) {
        this.log(4, string, throwable);
    }
}

