/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loaders.impl.resources;

import java.io.IOException;
import java.io.Reader;
import org.febit.wit.loaders.Resource;

public class LazyResource
implements Resource {
    protected final int timeout;
    protected final Resource resource;
    protected long expire;

    public LazyResource(Resource resource, int n) {
        this.timeout = n;
        this.resource = resource;
        this.expire = 0L;
    }

    @Override
    public boolean isModified() {
        if (this.expire >= System.currentTimeMillis()) {
            return false;
        }
        this.recalculateExpire();
        return this.resource.isModified();
    }

    @Override
    public Reader openReader() throws IOException {
        this.recalculateExpire();
        return this.resource.openReader();
    }

    private void recalculateExpire() {
        this.expire = System.currentTimeMillis() + (long)this.timeout;
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public boolean isCodeFirst() {
        return this.resource.isCodeFirst();
    }
}

