/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loaders.impl.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.febit.wit.loaders.Resource;

public class FileResource
implements Resource {
    protected final File file;
    protected final String encoding;
    protected final boolean codeFirst;
    protected long lastModified;

    public FileResource(String string, String string2) {
        this(string, string2, false);
    }

    public FileResource(File file, String string) {
        this(file, string, false);
    }

    public FileResource(String string, String string2, boolean bl) {
        this(new File(string), string2, bl);
    }

    public FileResource(File file, String string, boolean bl) {
        this.encoding = string;
        this.file = file;
        this.codeFirst = bl;
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    @Override
    public Reader openReader() throws IOException {
        this.lastModified = this.file.lastModified();
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isCodeFirst() {
        return this.codeFirst;
    }
}

