/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loaders.impl.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.febit.wit.exceptions.ResourceNotFoundException;
import org.febit.wit.loaders.Resource;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.InternedEncoding;

public class ClasspathResource
implements Resource {
    protected final String path;
    protected final String encoding;
    protected final boolean codeFirst;

    public ClasspathResource(String string, String string2) {
        this(string, string2, false);
    }

    public ClasspathResource(String string, String string2, boolean bl) {
        this.path = string;
        this.encoding = string2 != null ? string2 : InternedEncoding.UTF_8.value;
        this.codeFirst = bl;
    }

    @Override
    public boolean exists() {
        return ClassUtil.getDefaultClassLoader().getResource(this.path) != null;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public Reader openReader() throws IOException {
        InputStream inputStream = ClassUtil.getDefaultClassLoader().getResourceAsStream(this.path);
        if (inputStream == null) {
            throw new ResourceNotFoundException("Resource Not Found: ".concat(this.path));
        }
        return new InputStreamReader(inputStream, this.encoding);
    }

    @Override
    public boolean isCodeFirst() {
        return this.codeFirst;
    }
}

