/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loaders.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.febit.wit.Engine;
import org.febit.wit.Init;
import org.febit.wit.exceptions.IllegalConfigException;
import org.febit.wit.loaders.Loader;
import org.febit.wit.loaders.Resource;
import org.febit.wit.util.StringUtil;

public class RouteLoader
implements Loader {
    protected String loaders;
    protected Loader defaultLoader;
    protected LoaderEntry[] entrys;
    protected String[] rules;

    @Init
    public void init(Engine engine) {
        String[] stringArray = StringUtil.toArray(this.loaders);
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        HashMap<String, LoaderEntry> hashMap = new HashMap<String, LoaderEntry>();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                throw new IllegalConfigException("Illegal RouteLoader rule: ".concat(string2));
            }
            stringArray2[i] = string = string2.substring(0, n2);
            hashMap.put(string, new LoaderEntry(string, (Loader)engine.get(string2.substring(n2 + 1).trim())));
        }
        Arrays.sort(stringArray2, Comparator.reverseOrder());
        LoaderEntry[] loaderEntryArray = new LoaderEntry[n];
        for (int i = 0; i < n; ++i) {
            loaderEntryArray[i] = (LoaderEntry)hashMap.get(stringArray2[i]);
        }
        this.rules = stringArray2;
        this.entrys = loaderEntryArray;
    }

    protected LoaderEntry getLoaderEntry(String string) {
        String[] stringArray = this.rules;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return this.entrys[i];
        }
        return null;
    }

    @Override
    public Resource get(String string) {
        LoaderEntry loaderEntry = this.getLoaderEntry(string);
        if (loaderEntry != null) {
            return loaderEntry.get(string);
        }
        return this.defaultLoader.get(string);
    }

    @Override
    public String concat(String string, String string2) {
        LoaderEntry loaderEntry = this.getLoaderEntry(string2);
        if (loaderEntry != null) {
            return loaderEntry.normalize(string2);
        }
        LoaderEntry loaderEntry2 = this.getLoaderEntry(string);
        if (loaderEntry2 != null) {
            return loaderEntry2.concat(string, string2);
        }
        return this.defaultLoader.concat(string, string2);
    }

    @Override
    public String normalize(String string) {
        LoaderEntry loaderEntry = this.getLoaderEntry(string);
        if (loaderEntry != null) {
            return loaderEntry.normalize(string);
        }
        return this.defaultLoader.normalize(string);
    }

    @Override
    public boolean isEnableCache(String string) {
        LoaderEntry loaderEntry = this.getLoaderEntry(string);
        if (loaderEntry != null) {
            return loaderEntry.isEnableCache(string);
        }
        return this.defaultLoader.isEnableCache(string);
    }

    protected static class LoaderEntry {
        private final String prefix;
        private final Loader loader;
        private final int prefixLength;

        public LoaderEntry(String string, Loader loader) {
            this.prefix = string;
            this.loader = loader;
            this.prefixLength = string.length();
        }

        public Resource get(String string) {
            return this.loader.get(string.substring(this.prefixLength));
        }

        public String concat(String string, String string2) {
            return this.fix(this.loader.concat(string.substring(this.prefixLength), string2));
        }

        public String normalize(String string) {
            return this.fix(this.loader.normalize(string.substring(this.prefixLength)));
        }

        public String fix(String string) {
            if (string != null) {
                return this.prefix.concat(string);
            }
            return null;
        }

        private boolean isEnableCache(String string) {
            return this.loader.isEnableCache(string.substring(this.prefixLength));
        }
    }
}

