/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.loaders;

import org.febit.wit.Init;
import org.febit.wit.loaders.Loader;
import org.febit.wit.util.FileNameUtil;

public abstract class AbstractLoader
implements Loader {
    protected String encoding;
    protected String root;
    protected boolean appendLostSuffix;
    protected String suffix;
    protected String[] assistantSuffixs;
    protected boolean enableCache = true;
    protected boolean codeFirst;

    @Init
    public void init() {
        this.root = FileNameUtil.normalize(this.root);
        if (this.root != null && this.root.isEmpty()) {
            this.root = null;
        }
    }

    @Override
    public String concat(String string, String string2) {
        return string != null ? FileNameUtil.concat(FileNameUtil.getPath(string), string2) : string2;
    }

    protected String getRealPath(String string) {
        return this.root != null ? this.root.concat(string) : string.substring(1, string.length());
    }

    @Override
    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return "/";
        }
        if (string.charAt(0) != '/' && string.charAt(0) != '\\') {
            string = "/".concat(string);
        }
        if ((string = FileNameUtil.normalize(string)) == null) {
            return null;
        }
        if (!this.appendLostSuffix || string.endsWith(this.suffix) || string.charAt(string.length() - 1) == '/') {
            return string;
        }
        for (String string2 : this.assistantSuffixs) {
            if (!string.endsWith(string2)) continue;
            return string;
        }
        return string.concat(this.suffix);
    }

    @Override
    public boolean isEnableCache(String string) {
        return this.enableCache;
    }
}

