/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.lang.method;

import java.lang.reflect.Array;
import org.febit.wit.InternalContext;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.StringUtil;

public class NativeNewArrayDeclare
implements MethodDeclare {
    private final Class<?> componentType;

    public NativeNewArrayDeclare(Class<?> clazz) {
        this.componentType = clazz;
    }

    @Override
    public Object invoke(InternalContext internalContext, Object[] objectArray) {
        int n;
        if (objectArray != null && objectArray.length != 0) {
            Object object = objectArray[0];
            if (!(object instanceof Number)) {
                throw new ScriptRuntimeException("must given a number as array's length, but get : ".concat(ClassUtil.getClassName(object)));
            }
            n = ((Number)object).intValue();
            if (n < 0) {
                throw new ScriptRuntimeException(StringUtil.format("must given a nonnegative number as array's length: {}", n));
            }
        } else {
            n = 0;
        }
        return Array.newInstance(this.componentType, n);
    }
}

