/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.lang.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.febit.wit.InternalContext;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.util.JavaNativeUtil;

public class MultiNativeMethodDeclare
implements MethodDeclare {
    private final Method[] methods;
    private final boolean isStatic;

    public MultiNativeMethodDeclare(Method[] methodArray, boolean bl) {
        this.methods = methodArray;
        this.isStatic = bl;
    }

    @Override
    public Object invoke(InternalContext internalContext, Object[] objectArray) {
        Method method;
        if (this.isStatic) {
            method = JavaNativeUtil.getMatchMethod(this.methods, objectArray);
        } else {
            if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
                throw new ScriptRuntimeException("this method need one argument at least");
            }
            method = JavaNativeUtil.getMatchMethod(this.methods, Arrays.copyOfRange(objectArray, 1, objectArray.length));
        }
        if (method == null) {
            throw new ScriptRuntimeException("not found match native method");
        }
        return JavaNativeUtil.invokeMethod(method, objectArray);
    }
}

