/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io.impl;

import java.io.IOException;
import java.io.Writer;
import org.febit.wit.Engine;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.io.Buffers;
import org.febit.wit.io.Out;
import org.febit.wit.io.charset.CoderFactory;
import org.febit.wit.io.charset.Decoder;
import org.febit.wit.util.InternedEncoding;

public final class WriterOut
implements Out {
    private final Writer writer;
    private final InternedEncoding encoding;
    private final Decoder decoder;
    private final Buffers buffers;

    private WriterOut(Writer writer, InternedEncoding internedEncoding, Decoder decoder, Buffers buffers) {
        this.writer = writer;
        this.encoding = internedEncoding;
        this.decoder = decoder;
        this.buffers = buffers;
    }

    public WriterOut(Writer writer, InternedEncoding internedEncoding, Engine engine) {
        this(writer, internedEncoding != null ? internedEncoding : engine.getEncoding(), engine.getCoderFactory());
    }

    public WriterOut(Writer writer, Engine engine) {
        this(writer, engine.getEncoding(), engine.getCoderFactory());
    }

    public WriterOut(Writer writer, InternedEncoding internedEncoding, CoderFactory coderFactory) {
        this.writer = writer;
        this.encoding = internedEncoding;
        this.buffers = Buffers.getMiniPeers();
        this.decoder = coderFactory.newDecoder(internedEncoding, this.buffers);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            this.decoder.write(byArray, n, n2, this.writer);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray) {
        try {
            this.decoder.write(byArray, 0, byArray.length, this.writer);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        try {
            this.writer.write(cArray);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        try {
            char[] cArray = this.buffers.getChars(n2);
            string.getChars(n, n + n2, cArray, 0);
            this.writer.write(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public InternedEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isByteStream() {
        return false;
    }
}

