/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.febit.wit.Engine;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.io.Out;
import org.febit.wit.io.charset.CoderFactory;
import org.febit.wit.io.charset.Encoder;
import org.febit.wit.util.InternedEncoding;

public final class OutputStreamOut
implements Out {
    private final OutputStream outputStream;
    private final InternedEncoding encoding;
    private final Encoder encoder;

    private OutputStreamOut(OutputStream outputStream, InternedEncoding internedEncoding, Encoder encoder) {
        this.outputStream = outputStream;
        this.encoding = internedEncoding;
        this.encoder = encoder;
    }

    public OutputStreamOut(OutputStream outputStream, InternedEncoding internedEncoding, CoderFactory coderFactory) {
        this(outputStream, internedEncoding, coderFactory.newEncoder(internedEncoding));
    }

    public OutputStreamOut(OutputStream outputStream, OutputStreamOut outputStreamOut) {
        this(outputStream, outputStreamOut.encoding, outputStreamOut.encoder);
    }

    public OutputStreamOut(OutputStream outputStream, Engine engine) {
        this(outputStream, engine.getEncoding(), engine.getCoderFactory());
    }

    public OutputStreamOut(OutputStream outputStream, InternedEncoding internedEncoding, Engine engine) {
        this(outputStream, internedEncoding != null ? internedEncoding : engine.getEncoding(), engine.getCoderFactory());
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            this.outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray) {
        try {
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            this.encoder.write(cArray, n, n2, this.outputStream);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(String string, int n, int n2) {
        try {
            this.encoder.write(string, n, n2, this.outputStream);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public void write(String string) {
        try {
            this.encoder.write(string, 0, string.length(), this.outputStream);
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public InternedEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isByteStream() {
        return true;
    }
}

