/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io.charset.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.febit.wit.io.Buffers;
import org.febit.wit.io.charset.Encoder;
import org.febit.wit.util.charset.UTF8;

public final class UTF8Encoder
implements Encoder {
    private final Buffers buffers;

    public UTF8Encoder(Buffers buffers) {
        this.buffers = buffers;
    }

    @Override
    public void write(char[] cArray, int n, int n2, OutputStream outputStream) throws IOException {
        if (cArray == null || n2 == 0) {
            return;
        }
        byte[] byArray = this.buffers.getBytes(n2 * 3);
        int n3 = UTF8.encode(byArray, cArray, n, n + n2);
        outputStream.write(byArray, 0, n3);
    }

    @Override
    public void write(String string, int n, int n2, OutputStream outputStream) throws IOException {
        if (string == null) {
            return;
        }
        char[] cArray = this.buffers.getChars(n2);
        string.getChars(n, n + n2, cArray, 0);
        byte[] byArray = this.buffers.getBytes(n2 * 3);
        int n3 = UTF8.encode(byArray, cArray, n, n + n2);
        outputStream.write(byArray, 0, n3);
    }
}

