/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io.charset.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.febit.wit.io.Buffers;
import org.febit.wit.io.charset.Encoder;

public class DefaultEncoder
implements Encoder {
    private final CharsetEncoder charsetEncoder;
    private final double expansionFactor;
    private final Buffers buffers;

    public DefaultEncoder(String string, Buffers buffers) {
        this.charsetEncoder = DefaultEncoder.newEncoder(string);
        this.expansionFactor = this.charsetEncoder.maxBytesPerChar();
        this.buffers = buffers;
    }

    @Override
    public void write(String string, int n, int n2, OutputStream outputStream) throws IOException {
        char[] cArray = this.buffers.getChars(n2);
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2, outputStream);
    }

    @Override
    public void write(char[] cArray, int n, int n2, OutputStream outputStream) throws IOException {
        if (cArray == null || n2 == 0) {
            return;
        }
        CharsetEncoder charsetEncoder = this.charsetEncoder.reset();
        byte[] byArray = this.buffers.getBytes((int)((double)n2 * this.expansionFactor));
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        charsetEncoder.encode(CharBuffer.wrap(cArray, n, n2), byteBuffer, true);
        charsetEncoder.flush(byteBuffer);
        outputStream.write(byArray, 0, byteBuffer.position());
    }

    private static CharsetEncoder newEncoder(String string) {
        return Charset.forName(string).newEncoder();
    }
}

