/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io.charset.impl;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.febit.wit.io.Buffers;
import org.febit.wit.io.charset.Decoder;

public class DefaultDecoder
implements Decoder {
    private final CharsetDecoder charsetDecoder;
    private final double expansionFactor;
    private final Buffers buffers;

    public DefaultDecoder(String string, Buffers buffers) {
        this.charsetDecoder = DefaultDecoder.newDecoder(string);
        this.expansionFactor = this.charsetDecoder.maxCharsPerByte();
        this.buffers = buffers;
    }

    @Override
    public void write(byte[] byArray, int n, int n2, Writer writer) throws IOException {
        if (byArray == null || n2 == 0) {
            return;
        }
        CharsetDecoder charsetDecoder = this.charsetDecoder.reset();
        char[] cArray = this.buffers.getChars((int)((double)n2 * this.expansionFactor));
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        charsetDecoder.decode(ByteBuffer.wrap(byArray, n, n2), charBuffer, true);
        charsetDecoder.flush(charBuffer);
        writer.write(cArray, 0, charBuffer.position());
    }

    private static CharsetDecoder newDecoder(String string) {
        return Charset.forName(string).newDecoder();
    }
}

