/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.io;

import java.lang.ref.WeakReference;

public final class Buffers {
    private static final ThreadLocal<WeakReference<Buffers>> CACHE = new ThreadLocal();
    private char[] chars;
    private byte[] bytes;

    private Buffers(int n) {
        this.chars = new char[n];
        this.bytes = new byte[n];
    }

    public char[] getChars(int n) {
        char[] cArray = this.chars;
        return cArray.length >= n ? cArray : this.upgradeChars(n);
    }

    private char[] upgradeChars(int n) {
        this.chars = new char[Buffers.getAllocateLength(this.chars.length, n)];
        return this.chars;
    }

    public byte[] getBytes(int n) {
        byte[] byArray = this.bytes;
        return byArray.length >= n ? byArray : this.upgradeBytes(n);
    }

    private byte[] upgradeBytes(int n) {
        this.bytes = new byte[Buffers.getAllocateLength(this.bytes.length, n)];
        return this.bytes;
    }

    private static int getAllocateLength(int n, int n2) {
        int n3 = n;
        do {
            if (n3 < n2) continue;
            return n3;
        } while ((n3 <<= 1) <= 8192);
        return n2;
    }

    public static Buffers getNormalPeers() {
        return Buffers.createIfAbsent(256);
    }

    public static Buffers getMiniPeers() {
        return Buffers.createIfAbsent(32);
    }

    private static Buffers createIfAbsent(int n) {
        Buffers buffers;
        WeakReference<Buffers> weakReference = CACHE.get();
        if (weakReference == null || (buffers = (Buffers)weakReference.get()) == null) {
            if (weakReference != null) {
                weakReference.clear();
            }
            buffers = new Buffers(n);
            CACHE.set(new WeakReference<Buffers>(buffers));
        }
        return buffers;
    }
}

