/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.global;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.febit.wit.Init;
import org.febit.wit.global.GlobalRegister;
import org.febit.wit.lang.Bag;
import org.febit.wit.lang.MethodDeclare;

public class GlobalManager {
    private final ConcurrentMap<String, Object> constVars = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Object> globalVars = new ConcurrentHashMap<String, Object>();
    protected GlobalRegister[] registers;

    @Init
    public void init() {
        if (this.registers != null) {
            for (GlobalRegister globalRegister : this.registers) {
                globalRegister.regist(this);
            }
        }
    }

    public void clear() {
        this.constVars.clear();
        this.globalVars.clear();
        this.init();
    }

    public void forEachConst(BiConsumer<String, Object> biConsumer) {
        Objects.requireNonNull(biConsumer);
        this.constVars.forEach(biConsumer);
    }

    public void forEachGlobal(BiConsumer<String, Object> biConsumer) {
        Objects.requireNonNull(biConsumer);
        this.globalVars.forEach(biConsumer);
    }

    public boolean hasGlobal(String string) {
        return this.globalVars.containsKey(string);
    }

    public Object getGlobal(String string) {
        return this.globalVars.get(string);
    }

    public void setGlobal(String string, Object object) {
        this.globalVars.put(string, object);
    }

    public boolean hasConst(String string) {
        return this.constVars.containsKey(string);
    }

    public Object getConst(String string) {
        return this.constVars.get(string);
    }

    public void setConst(String string, Object object) {
        this.constVars.put(string, object);
    }

    public void setConstMethod(String string, MethodDeclare methodDeclare) {
        this.setConst(string, methodDeclare);
    }

    public Bag getConstBag() {
        return new Bag(){

            @Override
            public Object get(Object object) {
                return GlobalManager.this.getConst(String.valueOf(object));
            }

            @Override
            public void set(Object object, Object object2) {
                GlobalManager.this.setConst(String.valueOf(object), object2);
            }
        };
    }

    public Bag getGlobalBag() {
        return new Bag(){

            @Override
            public Object get(Object object) {
                return GlobalManager.this.getGlobal(String.valueOf(object));
            }

            @Override
            public void set(Object object, Object object2) {
                GlobalManager.this.setGlobal(String.valueOf(object), object2);
            }
        };
    }
}

