/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.febit.wit.Template;
import org.febit.wit.util.ExceptionUtil;

public abstract class TemplateException
extends RuntimeException {
    protected boolean isCaused;
    protected Template template;

    public TemplateException(String string) {
        super(string);
    }

    public TemplateException(Throwable throwable) {
        this(throwable.getMessage(), throwable);
    }

    public TemplateException(String string, Throwable throwable) {
        super(string, throwable);
        if (throwable instanceof TemplateException) {
            ((TemplateException)throwable).isCaused = true;
        }
    }

    protected abstract void printBody(ExceptionUtil.PrintStreamOrWriter var1, String var2);

    public Template getTemplate() {
        return this.template;
    }

    public TemplateException setTemplate(Template template) {
        this.template = template;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            this.printStackTrace(ExceptionUtil.wrap(printStream));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            this.printStackTrace(ExceptionUtil.wrap(printWriter));
        }
    }

    protected void printStackTrace(ExceptionUtil.PrintStreamOrWriter printStreamOrWriter) {
        String string = this.isCaused ? "\t" : "";
        printStreamOrWriter.print(string).print(this).print(Character.valueOf('\n'));
        if (this.template != null) {
            printStreamOrWriter.print(string).print("template: ").print(this.template.getName()).print(Character.valueOf('\n'));
        }
        this.printBody(printStreamOrWriter, string);
        Throwable throwable = this.getCause();
        if (throwable != null) {
            printStreamOrWriter.print(string).print("\tCaused by: \n");
            printStreamOrWriter.printTrace(throwable);
        }
    }
}

