/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.exceptions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.exceptions.TemplateException;
import org.febit.wit.util.ExceptionUtil;

public class ScriptRuntimeException
extends TemplateException {
    protected final List<Statement> statementStack = new ArrayList<Statement>(8);

    public ScriptRuntimeException(String string) {
        super(string);
    }

    public ScriptRuntimeException(String string, Statement statement) {
        super(string);
        this.addStatement(statement);
    }

    public ScriptRuntimeException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ScriptRuntimeException(String string, Throwable throwable, Statement statement) {
        super(string, throwable);
        this.addStatement(statement);
    }

    public ScriptRuntimeException(Throwable throwable) {
        super(throwable);
    }

    public ScriptRuntimeException(Throwable throwable, Statement statement) {
        super(throwable);
        this.addStatement(statement);
    }

    public final void addStatement(Statement statement) {
        this.statementStack.add(statement);
    }

    public List<Statement> getStatementStack() {
        return Collections.unmodifiableList(this.statementStack);
    }

    @Override
    protected void printBody(ExceptionUtil.PrintStreamOrWriter printStreamOrWriter, String string) {
        for (Statement statement : this.statementStack) {
            printStreamOrWriter.print(string).print("\tat ").print(statement.line).print(":").print(statement.column).print(" ").print(statement.getClass().getSimpleName()).print(Character.valueOf('\n'));
        }
    }
}

