/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.text.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.febit.wit.Template;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.text.TextStatementFactory;
import org.febit.wit.core.text.impl.ByteArrayTextStatement;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.io.charset.CoderFactory;
import org.febit.wit.io.charset.Encoder;
import org.febit.wit.util.InternedEncoding;

public class ByteArrayTextStatementFactory
implements TextStatementFactory {
    protected InternedEncoding encoding;
    protected CoderFactory coderFactory;
    protected final ThreadLocal<Encoder> encoders = new ThreadLocal();
    protected final ThreadLocal<ByteArrayOutputStream> outputs = new ThreadLocal();

    @Override
    public void startTemplateParser(Template template) {
        this.encoders.set(this.coderFactory.newEncoder(this.encoding));
        this.outputs.set(new ByteArrayOutputStream(512));
    }

    @Override
    public void finishTemplateParser(Template template) {
        this.encoders.remove();
        this.outputs.remove();
    }

    protected byte[] getBytes(char[] cArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.outputs.get();
            this.encoders.get().write(cArray, 0, cArray.length, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ScriptRuntimeException(iOException);
        }
    }

    @Override
    public Statement getTextStatement(Template template, char[] cArray, int n, int n2) {
        return new ByteArrayTextStatement(this.getBytes(cArray), n, n2);
    }
}

