/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.DoWhile;
import org.febit.wit.core.ast.statements.DoWhileNoLoops;
import org.febit.wit.core.ast.statements.IBlock;
import org.febit.wit.core.ast.statements.While;
import org.febit.wit.core.ast.statements.WhileNoLoops;
import org.febit.wit.util.StatementUtil;

public class WhilePart {
    private final int line;
    private final int column;
    private Expression whileExpr;
    private IBlock bodyStatement;
    private boolean doWhileAtFirst;

    public WhilePart(Expression expression, IBlock iBlock, boolean bl, int n, int n2) {
        this.line = n;
        this.column = n2;
        this.whileExpr = expression;
        this.bodyStatement = iBlock;
        this.doWhileAtFirst = bl;
    }

    public Statement pop(int n) {
        if (this.bodyStatement.hasLoops()) {
            LoopInfo[] loopInfoArray = StatementUtil.collectPossibleLoopsForWhile(this.bodyStatement, null, n);
            return this.doWhileAtFirst ? new While(this.whileExpr, this.bodyStatement.getVarIndexer(), this.bodyStatement.getStatements(), loopInfoArray, n, this.line, this.column) : new DoWhile(this.whileExpr, this.bodyStatement.getVarIndexer(), this.bodyStatement.getStatements(), loopInfoArray, n, this.line, this.column);
        }
        return this.doWhileAtFirst ? new WhileNoLoops(this.whileExpr, this.bodyStatement.getVarIndexer(), this.bodyStatement.getStatements(), this.line, this.column) : new DoWhileNoLoops(this.whileExpr, this.bodyStatement.getVarIndexer(), this.bodyStatement.getStatements(), this.line, this.column);
    }
}

