/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.NoneStatement;
import org.febit.wit.core.ast.statements.TryCatchFinally;
import org.febit.wit.core.ast.statements.TryFinally;
import org.febit.wit.util.StatementUtil;

public class TryPart {
    protected final int line;
    protected final int column;
    protected final Statement tryStat;
    protected int exceptionVarIndex;
    protected Statement catchStat;
    protected Statement finalStat;

    public TryPart(Statement statement, int n, int n2) {
        this.line = n;
        this.column = n2;
        this.tryStat = StatementUtil.optimize(statement);
    }

    public TryPart setCatchStat(int n, Statement statement) {
        this.exceptionVarIndex = n;
        this.catchStat = StatementUtil.optimize(statement);
        return this;
    }

    public TryPart setFinalStat(Statement statement) {
        this.finalStat = StatementUtil.optimize(statement);
        return this;
    }

    public Statement pop() {
        if (this.tryStat == null) {
            return this.finalStat != null ? this.finalStat : NoneStatement.INSTANCE;
        }
        if (this.catchStat == null) {
            return this.finalStat != null ? new TryFinally(this.tryStat, this.finalStat, this.line, this.column) : this.tryStat;
        }
        return new TryCatchFinally(this.tryStat, this.exceptionVarIndex, this.catchStat, this.finalStat, this.line, this.column);
    }
}

