/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.HashMap;
import java.util.Map;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.Switch;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.util.StatementUtil;

public class SwitchPart {
    private int line;
    private int column;
    private Expression switchExpr;
    private Switch.CaseEntry defaultStatement;
    private final Map<Object, Switch.CaseEntry> caseMap = new HashMap<Object, Switch.CaseEntry>();
    private Switch.CaseEntry currentCaseStatement = null;

    public SwitchPart setSwitchExpr(Expression expression, int n, int n2) {
        this.switchExpr = expression;
        this.line = n;
        this.column = n2;
        return this;
    }

    public SwitchPart appendCase(Object object, Statement statement, int n, int n2) {
        statement = StatementUtil.optimize(statement);
        Switch.CaseEntry caseEntry = this.currentCaseStatement;
        if (statement != null) {
            caseEntry = this.currentCaseStatement = new Switch.CaseEntry(statement, caseEntry);
        }
        if (object == null) {
            if (this.defaultStatement != null) {
                throw new ParseException("multi default block in one swith", n, n2);
            }
            this.defaultStatement = caseEntry;
        } else if (this.caseMap.containsKey(object)) {
            throw new ParseException("duplicated case value in one swith", n, n2);
        }
        this.caseMap.put(object, caseEntry);
        return this;
    }

    public Statement pop(int n) {
        HashMap<Object, Switch.CaseEntry> hashMap = new HashMap<Object, Switch.CaseEntry>((this.caseMap.size() + 1) * 4 / 3, 0.75f);
        hashMap.putAll(this.caseMap);
        return StatementUtil.optimize(new Switch(this.switchExpr, this.defaultStatement, hashMap, n, this.line, this.column));
    }
}

