/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.util.StatementUtil;

public final class Switch
extends Statement
implements Loopable {
    private final Expression switchExpr;
    private final CaseEntry defaultStatement;
    private final Map<Object, CaseEntry> caseMap;
    private final int label;

    Switch(Expression expression, CaseEntry caseEntry, Map<Object, CaseEntry> map, int n, int n2, int n3) {
        super(n2, n3);
        this.switchExpr = expression;
        this.defaultStatement = caseEntry;
        this.caseMap = map;
        this.label = n;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        CaseEntry caseEntry = this.caseMap.get(this.switchExpr.execute(internalContext));
        if (caseEntry == null) {
            caseEntry = this.defaultStatement;
        }
        if (caseEntry != null) {
            caseEntry.execute(internalContext);
            internalContext.resetBreakLoopIfMatch(this.label);
        }
        return null;
    }

    @Override
    public List<LoopInfo> collectPossibleLoops() {
        LinkedList<LoopInfo> linkedList = new LinkedList<LoopInfo>();
        this.caseMap.values().forEach(caseEntry -> linkedList.addAll(caseEntry.collectPossibleLoops()));
        linkedList.removeIf(loopInfo -> loopInfo.matchLabel(this.label) && loopInfo.type == 1);
        return linkedList;
    }

    static final class CaseEntry {
        final Statement body;
        final CaseEntry next;

        CaseEntry(Statement statement, CaseEntry caseEntry) {
            this.body = statement;
            this.next = caseEntry;
        }

        Object execute(InternalContext internalContext) {
            this.body.execute(internalContext);
            if (internalContext.noLoop() && this.next != null) {
                return this.next.execute(internalContext);
            }
            return null;
        }

        List<LoopInfo> collectPossibleLoops() {
            return StatementUtil.collectPossibleLoops(this.body);
        }
    }
}

