/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.ArrayList;
import java.util.List;
import org.febit.wit.Template;
import org.febit.wit.core.ast.AssignableExpression;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.Import;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.util.StatementUtil;

public class ImportPart {
    protected final int line;
    protected final int column;
    private Expression expr;
    private Expression paramsExpr;
    private List<String> exportNameList;
    private List<AssignableExpression> toResetableValueList;

    public ImportPart(Expression expression, Expression expression2, int n, int n2) {
        this.line = n;
        this.column = n2;
        this.expr = StatementUtil.optimize(expression);
        this.paramsExpr = StatementUtil.optimize(expression2);
        this.exportNameList = new ArrayList<String>();
        this.toResetableValueList = new ArrayList<AssignableExpression>();
    }

    public ImportPart append(String string, Expression expression) {
        if (!((expression = StatementUtil.optimize(expression)) instanceof AssignableExpression)) {
            throw new ParseException("Need a resetable expression.", (Statement)expression);
        }
        this.exportNameList.add(string);
        this.toResetableValueList.add((AssignableExpression)expression);
        return this;
    }

    public Import pop(Template template) {
        String string = template.getName();
        int n = this.exportNameList.size();
        return n == 0 ? new Import(this.expr, this.paramsExpr, null, null, string, this.line, this.column) : new Import(this.expr, this.paramsExpr, this.exportNameList.toArray(new String[n]), this.toResetableValueList.toArray(new AssignableExpression[n]), string, this.line, this.column);
    }
}

