/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.List;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.expressions.FunctionDeclare;
import org.febit.wit.lang.KeyIter;
import org.febit.wit.lang.iter.KeyIterMethodFilter;
import org.febit.wit.util.CollectionUtil;
import org.febit.wit.util.StatementUtil;

public final class ForMap
extends Statement
implements Loopable {
    private final FunctionDeclare functionDeclareExpr;
    private final Expression mapExpr;
    private final int indexer;
    private final Statement[] statements;
    private final LoopInfo[] possibleLoops;
    private final Statement elseStatement;
    private final int label;
    private final int iterIndex;
    private final int keyIndex;
    private final int valueIndex;

    public ForMap(FunctionDeclare functionDeclare, Expression expression, int n, int n2, int n3, int n4, Statement[] statementArray, LoopInfo[] loopInfoArray, Statement statement, int n5, int n6, int n7) {
        super(n6, n7);
        this.functionDeclareExpr = functionDeclare;
        this.mapExpr = expression;
        this.indexer = n;
        this.statements = statementArray;
        this.possibleLoops = loopInfoArray;
        this.elseStatement = statement;
        this.label = n5;
        this.iterIndex = n2;
        this.keyIndex = n3;
        this.valueIndex = n4;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        KeyIter keyIter = CollectionUtil.toKeyIter(this.mapExpr.execute(internalContext), this);
        if (keyIter != null && this.functionDeclareExpr != null) {
            keyIter = new KeyIterMethodFilter(internalContext, this.functionDeclareExpr.execute(internalContext), keyIter);
        }
        if (keyIter != null && keyIter.hasNext()) {
            int n = internalContext.indexer;
            internalContext.indexer = this.indexer;
            Statement[] statementArray = this.statements;
            int n2 = this.label;
            int n3 = this.keyIndex;
            int n4 = this.valueIndex;
            Object[] objectArray = internalContext.vars;
            objectArray[this.iterIndex] = keyIter;
            block5: do {
                objectArray[n3] = keyIter.next();
                objectArray[n4] = keyIter.value();
                StatementUtil.executeWithLoopCheck(statementArray, internalContext);
                if (internalContext.noLoop()) continue;
                if (!internalContext.matchLabel(n2)) break;
                switch (internalContext.getLoopType()) {
                    case 1: {
                        internalContext.resetLoop();
                        break block5;
                    }
                    case 3: {
                        break block5;
                    }
                    case 2: {
                        internalContext.resetLoop();
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            } while (keyIter.hasNext());
            internalContext.indexer = n;
            return null;
        }
        if (this.elseStatement != null) {
            this.elseStatement.execute(internalContext);
        }
        return null;
    }

    @Override
    public List<LoopInfo> collectPossibleLoops() {
        return StatementUtil.asList(this.possibleLoops);
    }
}

