/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.List;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.expressions.FunctionDeclare;
import org.febit.wit.lang.Iter;
import org.febit.wit.lang.iter.IterMethodFilter;
import org.febit.wit.util.CollectionUtil;
import org.febit.wit.util.StatementUtil;

public class ForIn
extends Statement
implements Loopable {
    protected final FunctionDeclare functionDeclareExpr;
    protected final Expression collectionExpr;
    protected final int indexer;
    protected final Statement[] statements;
    protected final LoopInfo[] possibleLoops;
    protected final Statement elseStatement;
    protected final int label;
    protected final int iterIndex;
    protected final int itemIndex;

    public ForIn(FunctionDeclare functionDeclare, Expression expression, int n, int n2, int n3, Statement[] statementArray, LoopInfo[] loopInfoArray, Statement statement, int n4, int n5, int n6) {
        super(n5, n6);
        this.functionDeclareExpr = functionDeclare;
        this.collectionExpr = expression;
        this.indexer = n;
        this.statements = statementArray;
        this.possibleLoops = loopInfoArray;
        this.elseStatement = statement;
        this.label = n4;
        this.iterIndex = n2;
        this.itemIndex = n3;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        Iter iter = CollectionUtil.toIter(this.collectionExpr.execute(internalContext), this);
        if (iter != null && this.functionDeclareExpr != null) {
            iter = new IterMethodFilter(internalContext, this.functionDeclareExpr.execute(internalContext), iter);
        }
        if (iter != null && iter.hasNext()) {
            int n = internalContext.indexer;
            internalContext.indexer = this.indexer;
            Statement[] statementArray = this.statements;
            int n2 = this.label;
            int n3 = this.itemIndex;
            Object[] objectArray = internalContext.vars;
            objectArray[this.iterIndex] = iter;
            block5: do {
                objectArray[n3] = iter.next();
                StatementUtil.executeWithLoopCheck(statementArray, internalContext);
                if (internalContext.noLoop()) continue;
                if (!internalContext.matchLabel(n2)) break;
                switch (internalContext.getLoopType()) {
                    case 1: {
                        internalContext.resetLoop();
                        break block5;
                    }
                    case 3: {
                        break block5;
                    }
                    case 2: {
                        internalContext.resetLoop();
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            } while (iter.hasNext());
            internalContext.indexer = n;
            return null;
        }
        if (this.elseStatement != null) {
            this.elseStatement.execute(internalContext);
        }
        return null;
    }

    @Override
    public List<LoopInfo> collectPossibleLoops() {
        return StatementUtil.asList(this.possibleLoops);
    }
}

