/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.List;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.util.ALU;
import org.febit.wit.util.StatementUtil;

public final class DoWhile
extends Statement
implements Loopable {
    private final Expression whileExpr;
    private final int indexer;
    private final Statement[] statements;
    private final LoopInfo[] possibleLoops;
    private final int label;

    public DoWhile(Expression expression, int n, Statement[] statementArray, LoopInfo[] loopInfoArray, int n2, int n3, int n4) {
        super(n3, n4);
        this.whileExpr = expression;
        this.indexer = n;
        this.statements = statementArray;
        this.possibleLoops = loopInfoArray;
        this.label = n2;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        Statement[] statementArray = this.statements;
        int n = this.label;
        int n2 = internalContext.indexer;
        internalContext.indexer = this.indexer;
        block5: do {
            StatementUtil.executeWithLoopCheck(statementArray, internalContext);
            if (internalContext.noLoop()) continue;
            if (!internalContext.matchLabel(n)) break;
            switch (internalContext.getLoopType()) {
                case 1: {
                    internalContext.resetLoop();
                    break block5;
                }
                case 3: {
                    break block5;
                }
                case 2: {
                    internalContext.resetLoop();
                    break;
                }
                default: {
                    break block5;
                }
            }
        } while (ALU.isTrue(this.whileExpr.execute(internalContext)));
        internalContext.indexer = n2;
        return null;
    }

    @Override
    public List<LoopInfo> collectPossibleLoops() {
        return StatementUtil.asList(this.possibleLoops);
    }
}

