/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.IBlock;
import org.febit.wit.util.StatementUtil;

public class BlockNoLoops
extends IBlock {
    private final int indexer;
    private final Statement[] statements;

    public BlockNoLoops(int n, Statement[] statementArray, int n2, int n3) {
        super(n2, n3);
        this.indexer = n;
        this.statements = statementArray;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        int n = internalContext.indexer;
        internalContext.indexer = this.indexer;
        StatementUtil.execute(this.statements, internalContext);
        internalContext.indexer = n;
        return null;
    }

    @Override
    public int getVarIndexer() {
        return this.indexer;
    }

    @Override
    public Statement[] getStatements() {
        return this.statements;
    }

    @Override
    public boolean hasLoops() {
        return false;
    }

    @Override
    public Statement optimize() {
        return this.statements.length == 0 ? null : this;
    }
}

