/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.List;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.statements.IBlock;
import org.febit.wit.util.StatementUtil;

public final class Block
extends IBlock
implements Loopable {
    private final int indexer;
    private final Statement[] statements;
    private final LoopInfo[] possibleLoops;

    public Block(int n, Statement[] statementArray, LoopInfo[] loopInfoArray, int n2, int n3) {
        super(n2, n3);
        this.indexer = n;
        this.statements = statementArray;
        this.possibleLoops = loopInfoArray;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        int n = internalContext.indexer;
        internalContext.indexer = this.indexer;
        StatementUtil.executeWithLoopCheck(this.statements, internalContext);
        internalContext.indexer = n;
        return null;
    }

    @Override
    public List<LoopInfo> collectPossibleLoops() {
        return StatementUtil.asList(this.possibleLoops);
    }

    @Override
    public boolean hasLoops() {
        return true;
    }

    @Override
    public int getVarIndexer() {
        return this.indexer;
    }

    @Override
    public Statement[] getStatements() {
        return this.statements;
    }
}

