/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.statements;

import java.util.HashMap;
import java.util.Map;
import org.febit.wit.Context;
import org.febit.wit.InternalContext;
import org.febit.wit.Template;
import org.febit.wit.Vars;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.expressions.DirectValue;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.exceptions.ResourceNotFoundException;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.util.StatementUtil;

public abstract class AbstractInclude
extends Statement {
    private static final Expression EXPR_EMPTY_PARAMS = new DirectValue(null, -1, -1);
    private final Expression pathExpr;
    private final Expression paramsExpr;
    private final String refer;

    public AbstractInclude(Expression expression, Expression expression2, String string, int n, int n2) {
        super(n, n2);
        this.pathExpr = StatementUtil.optimize(expression);
        this.paramsExpr = expression2 == null ? EXPR_EMPTY_PARAMS : StatementUtil.optimize(expression2);
        this.refer = string;
    }

    protected Vars prepareParams(InternalContext internalContext) {
        Vars vars;
        Object object = this.paramsExpr.execute(internalContext);
        if (object == null) {
            vars = Vars.EMPTY;
        } else if (object instanceof Map) {
            vars = Vars.of((Map)object);
        } else {
            throw new ScriptRuntimeException("Template param must be a Map.", (Statement)this.paramsExpr);
        }
        return internalContext.getEngine().isShareRootData() ? Vars.of(internalContext.getRootParams(), vars) : vars;
    }

    protected Map<String, Object> mergeTemplate(InternalContext internalContext, boolean bl) {
        Object object = this.pathExpr.execute(internalContext);
        if (object == null) {
            throw new ScriptRuntimeException("Template name should not be null.", (Statement)this.pathExpr);
        }
        try {
            Template template = internalContext.getEngine().getTemplate(this.refer, String.valueOf(object));
            Context context = template.mergeToContext(internalContext, this.prepareParams(internalContext));
            if (bl) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                context.exportTo(hashMap);
                return hashMap;
            }
            return null;
        }
        catch (ParseException | ResourceNotFoundException | ScriptRuntimeException exception) {
            throw new ScriptRuntimeException(exception, (Statement)this);
        }
    }
}

