/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.operators;

import java.util.function.Function;
import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.expressions.DirectValue;
import org.febit.wit.util.StatementUtil;

public class ConstableOperator
extends Expression {
    protected final Expression expr;
    protected final Function<Object, Object> op;

    public ConstableOperator(Expression expression, Function<Object, Object> function, int n, int n2) {
        super(n, n2);
        this.expr = expression;
        this.op = function;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        try {
            return this.op.apply(this.expr.execute(internalContext));
        }
        catch (Exception exception) {
            throw StatementUtil.castToScriptRuntimeException(exception, this);
        }
    }

    @Override
    public Expression optimize() {
        if (StatementUtil.isImmutableDirectValue(this.expr)) {
            return new DirectValue(this.op.apply(((DirectValue)this.expr).value), this.line, this.column);
        }
        return this;
    }

    @Override
    public Object getConstValue() {
        return this.op.apply(StatementUtil.calcConst(this.expr));
    }
}

