/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.operators;

import java.util.Objects;
import java.util.function.BiFunction;
import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.expressions.DirectValue;
import org.febit.wit.core.ast.operators.BiOperator;
import org.febit.wit.util.StatementUtil;

public class ConstableBiOperator
extends BiOperator {
    protected final BiFunction<Object, Object, Object> op;

    public ConstableBiOperator(Expression expression, Expression expression2, BiFunction<Object, Object, Object> biFunction, int n, int n2) {
        super(expression, expression2, n, n2);
        Objects.requireNonNull(biFunction);
        this.op = biFunction;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        try {
            return this.op.apply(this.leftExpr.execute(internalContext), this.rightExpr.execute(internalContext));
        }
        catch (Exception exception) {
            throw StatementUtil.castToScriptRuntimeException(exception, this);
        }
    }

    @Override
    public Expression optimize() {
        if (StatementUtil.isImmutableDirectValue(this.leftExpr) && StatementUtil.isImmutableDirectValue(this.rightExpr)) {
            return new DirectValue(this.op.apply(((DirectValue)this.leftExpr).value, ((DirectValue)this.rightExpr).value), this.line, this.column);
        }
        return this;
    }

    @Override
    public Object getConstValue() {
        return this.op.apply(StatementUtil.calcConst(this.leftExpr), StatementUtil.calcConst(this.rightExpr));
    }
}

