/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.expressions;

import java.lang.reflect.Field;
import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.AssignableExpression;
import org.febit.wit.exceptions.ScriptRuntimeException;

public class NativeStaticValue
extends AssignableExpression {
    private final Field field;

    public NativeStaticValue(Field field, int n, int n2) {
        super(n, n2);
        this.field = field;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        try {
            return this.field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return new ScriptRuntimeException("Failed to get static field value: ".concat(this.field.toString()), exception, this);
        }
    }

    @Override
    public Object setValue(InternalContext internalContext, Object object) {
        try {
            this.field.set(null, object);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return new ScriptRuntimeException("Failed to set static field value: ".concat(this.field.toString()), exception, this);
        }
    }
}

