/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.expressions;

import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.lang.UnConstableMethodDeclare;
import org.febit.wit.util.StatementUtil;

public final class MethodExecute
extends Expression {
    private final Expression funcExpr;
    private final Expression[] paramExprs;

    public MethodExecute(Expression expression, Expression[] expressionArray, int n, int n2) {
        super(n, n2);
        this.funcExpr = expression;
        this.paramExprs = expressionArray;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        Object object = this.funcExpr.execute(internalContext);
        if (!(object instanceof MethodDeclare)) {
            throw new ScriptRuntimeException("not a function", (Statement)this);
        }
        Object[] objectArray = StatementUtil.execute(this.paramExprs, internalContext);
        return ((MethodDeclare)object).invoke(internalContext, objectArray);
    }

    @Override
    public Object getConstValue() {
        Object object = StatementUtil.calcConst(this.funcExpr);
        if (!(object instanceof MethodDeclare)) {
            throw new ScriptRuntimeException("not a function", (Statement)this);
        }
        if (object instanceof UnConstableMethodDeclare) {
            return InternalContext.VOID;
        }
        Object[] objectArray = StatementUtil.calcConstArray(this.paramExprs);
        return ((MethodDeclare)object).invoke(null, objectArray);
    }
}

