/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.expressions;

import java.util.HashMap;
import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.util.StatementUtil;

public final class MapValue
extends Expression {
    private final Expression[] keyExprs;
    private final Expression[] valueExprs;
    private final int initialCapacity;

    public MapValue(Expression[] expressionArray, Expression[] expressionArray2, int n, int n2) {
        super(n, n2);
        StatementUtil.optimize(expressionArray);
        StatementUtil.optimize(expressionArray2);
        this.keyExprs = expressionArray;
        this.valueExprs = expressionArray2;
        this.initialCapacity = Math.max((expressionArray.length + 1) * 4 / 3, 4);
    }

    @Override
    public Object execute(InternalContext internalContext) {
        Expression[] expressionArray = this.keyExprs;
        Expression[] expressionArray2 = this.valueExprs;
        int n = expressionArray2.length;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.initialCapacity, 0.75f);
        for (int i = 0; i < n; ++i) {
            hashMap.put(expressionArray[i].execute(internalContext), expressionArray2[i].execute(internalContext));
        }
        return hashMap;
    }

    @Override
    public Object getConstValue() {
        Expression[] expressionArray = this.keyExprs;
        Expression[] expressionArray2 = this.valueExprs;
        int n = expressionArray.length;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.initialCapacity, 0.75f);
        for (int i = 0; i < n; ++i) {
            hashMap.put(StatementUtil.calcConst(expressionArray[i]), StatementUtil.calcConst(expressionArray2[i]));
        }
        return hashMap;
    }
}

