/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.VariantIndexer;
import org.febit.wit.core.VariantManager;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.expressions.ContextValue;
import org.febit.wit.core.ast.expressions.FunctionDeclare;
import org.febit.wit.core.ast.operators.Assign;
import org.febit.wit.core.ast.statements.Return;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.util.StatementUtil;
import org.febit.wit.util.StringUtil;

public class FunctionDeclarePart {
    protected final int line;
    protected final int column;
    private final int assignToIndex;
    private final int assignVariantStart;
    private final VariantManager varmgr;
    private final List<ArgumentInfo> args;

    public FunctionDeclarePart(String string, VariantManager variantManager, int n, int n2) {
        this(variantManager.assignVariant(string, n, n2), variantManager, n, n2);
    }

    public FunctionDeclarePart(VariantManager variantManager, int n, int n2) {
        this(-1, variantManager, n, n2);
    }

    protected FunctionDeclarePart(int n, VariantManager variantManager, int n2, int n3) {
        this.line = n2;
        this.column = n3;
        this.varmgr = variantManager;
        this.assignToIndex = n;
        this.args = new ArrayList<ArgumentInfo>();
        variantManager.pushScope();
        this.assignVariantStart = variantManager.assignVariant("arguments", n2, n3);
    }

    public FunctionDeclarePart appendArgs(List<ArgumentInfo> list) {
        if (list != null) {
            list.forEach(this::appendArg);
        }
        return this;
    }

    public FunctionDeclarePart appendArg(String string) {
        return this.appendArg(string, null);
    }

    public FunctionDeclarePart appendArg(String string, Object object) {
        return this.appendArg(new ArgumentInfo(string, object));
    }

    public FunctionDeclarePart appendArg(ArgumentInfo argumentInfo) {
        if (this.varmgr.assignVariant(argumentInfo.name, this.line, this.column) != this.assignVariantStart + (this.args.size() + 1)) {
            throw new ParseException("Failed to assign vars!");
        }
        this.args.add(argumentInfo);
        return this;
    }

    public String getArg(int n) {
        return this.args.get((int)n).name;
    }

    public Expression pop(Expression expression) {
        return this.pop(FunctionDeclarePart.toStatementList(expression));
    }

    public FunctionDeclare popFunctionDeclare(Expression expression) {
        return this.popFunctionDeclare(FunctionDeclarePart.toStatementList(expression));
    }

    private static List<Statement> toStatementList(Expression expression) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(1);
        arrayList.add(new Return(expression, expression.line, expression.column));
        return arrayList;
    }

    public Expression pop(List<Statement> list) {
        FunctionDeclare functionDeclare = this.popFunctionDeclare(list);
        if (this.assignToIndex >= 0) {
            return new Assign(new ContextValue(this.assignToIndex, this.line, this.column), functionDeclare, this.line, this.column);
        }
        return functionDeclare;
    }

    public FunctionDeclare popFunctionDeclare(List<Statement> list) {
        return this.popFunctionDeclare(StatementUtil.toStatementArray(list));
    }

    protected FunctionDeclare popFunctionDeclare(Statement[] statementArray) {
        VariantIndexer[] variantIndexerArray = this.varmgr.getIndexers();
        int n = this.varmgr.getVarCount();
        this.varmgr.popScope();
        boolean bl = false;
        ArrayList<LoopInfo> arrayList = new ArrayList<LoopInfo>();
        for (LoopInfo loopInfo : StatementUtil.collectPossibleLoops(statementArray)) {
            if (loopInfo.type == 3) {
                bl = true;
                continue;
            }
            arrayList.add(loopInfo);
        }
        if (!arrayList.isEmpty()) {
            throw new ParseException("Loops overflow in function body: ".concat(StringUtil.join(arrayList, ',')));
        }
        Object[] objectArray = new Object[this.args.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.args.get((int)i).defaultValue;
        }
        return new FunctionDeclare(objectArray, n, variantIndexerArray, statementArray, this.assignVariantStart, bl, this.line, this.column);
    }

    public static class ArgumentInfo {
        public final String name;
        public final Object defaultValue;

        public ArgumentInfo(String string, Object object) {
            this.name = string;
            this.defaultValue = object;
        }
    }
}

