/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core.ast.expressions;

import java.lang.reflect.Method;
import org.febit.wit.InternalContext;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.JavaNativeUtil;
import org.febit.wit.util.StatementUtil;

public final class DynamicNativeMethodExecute
extends Expression {
    private final String func;
    private final Expression thisExpr;
    private final Expression[] paramExprs;

    public DynamicNativeMethodExecute(Expression expression, String string, Expression[] expressionArray, int n, int n2) {
        super(n, n2);
        this.thisExpr = expression;
        this.func = string;
        this.paramExprs = expressionArray;
    }

    @Override
    public Object execute(InternalContext internalContext) {
        Object object = this.thisExpr.execute(internalContext);
        Method[] methodArray = this.getMethods(object);
        Object[] objectArray = StatementUtil.execute(this.paramExprs, internalContext);
        return this.invokeProperMethod(object, methodArray, objectArray);
    }

    @Override
    public Object getConstValue() {
        Object object = StatementUtil.calcConst(this.thisExpr);
        Method[] methodArray = this.getMethods(object);
        Object[] objectArray = StatementUtil.calcConstArray(this.paramExprs);
        return this.invokeProperMethod(object, methodArray, objectArray);
    }

    private Method[] getMethods(Object object) {
        if (object == null) {
            throw new ScriptRuntimeException("not a function (NPE)", (Statement)this);
        }
        Method[] methodArray = ClassUtil.getPublicMemberMethods(object.getClass(), this.func);
        if (methodArray.length == 0) {
            throw new ScriptRuntimeException("not found match native method: " + object.getClass() + '#' + this.func);
        }
        return methodArray;
    }

    private Object invokeProperMethod(Object object, Method[] methodArray, Object[] objectArray) {
        Method method = JavaNativeUtil.getMatchMethod(methodArray, objectArray);
        if (method == null) {
            throw new ScriptRuntimeException("not found match native method: " + object.getClass() + '#' + this.func);
        }
        return JavaNativeUtil.invokeMethod(method, object, objectArray);
    }
}

