/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.febit.wit.Engine;
import org.febit.wit.core.VariantIndexer;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.global.GlobalManager;
import org.febit.wit.util.ArrayUtil;
import org.febit.wit.util.Stack;

public class VariantManager {
    private int varCount;
    private int scopeLevelCount;
    private final Stack<Integer> varCountStack;
    private final Stack<VarStair> stairStack;
    private final List<VarStair> stairs;
    private final VarStair root;
    private final GlobalManager globalManager;

    VariantManager(Engine engine) {
        this.globalManager = engine.getGlobalManager();
        this.stairs = new ArrayList<VarStair>();
        this.stairStack = new Stack();
        this.varCountStack = new Stack();
        this.root = this.push(-1);
        this.root.assignVarsIfAbsent(engine.getVars());
    }

    private VarStair push(int n) {
        VarStair varStair = new VarStair(this.stairs.size(), n);
        this.stairs.add(varStair);
        this.stairStack.push(varStair);
        return varStair;
    }

    public void push() {
        this.push(this.stairStack.peek().id);
    }

    public void pushScope() {
        ++this.scopeLevelCount;
        this.varCountStack.push(this.varCount);
        this.varCount = 0;
        this.push();
    }

    public void popScope() {
        --this.scopeLevelCount;
        this.varCount = this.varCountStack.pop();
        this.pop();
    }

    public int getVarCount() {
        return this.varCount;
    }

    public int pop() {
        return this.stairStack.pop().id;
    }

    public VariantIndexer[] getIndexers() {
        int n;
        List<VarStair> list = this.stairs;
        int n2 = list.size();
        VariantIndexer[] variantIndexerArray = new VariantIndexer[n2];
        for (n = 0; n < n2 && list.get((int)n).scopeLevel != this.scopeLevelCount; ++n) {
        }
        int n3 = n;
        while (n < n2) {
            VarStair varStair = list.get(n);
            Map<String, Integer> map = varStair.values;
            if (varStair.constMap != null) {
                varStair.constMap.keySet().forEach(map::remove);
            }
            variantIndexerArray[n] = VariantManager.getVariantIndexer(varStair.parentId >= 0 ? variantIndexerArray[varStair.parentId] : null, map);
            ++n;
        }
        return Arrays.copyOfRange(variantIndexerArray, n3, n2);
    }

    public int assignVariant(String string, int n, int n2) {
        return this.stairStack.peek().assignVar(string, n, n2);
    }

    public void assignConst(String string, Object object, int n, int n2) {
        this.stairStack.peek().assignConst(string, object, n, n2);
    }

    public VarAddress locateAtUpstair(String string, int n, int n2, int n3) {
        VarAddress varAddress = this.stairStack.peek(n).locate(string);
        if (varAddress != null) {
            return varAddress;
        }
        throw new ParseException("Can't locate vars: ".concat(string), n2, n3);
    }

    public VarAddress locate(String string, int n, boolean bl, int n2, int n3) {
        Object object;
        while (n < this.stairStack.size()) {
            object = this.stairStack.peek(n).locate(string);
            if (object != null) {
                return object;
            }
            ++n;
        }
        object = this.globalManager;
        if (((GlobalManager)object).hasGlobal(string)) {
            return this.globalAddress(string);
        }
        if (((GlobalManager)object).hasConst(string)) {
            return this.constAddress(((GlobalManager)object).getConst(string));
        }
        if (bl) {
            throw new ParseException("Can't locate vars: ".concat(string), n2, n3);
        }
        return this.contextAddress(this.root.scopeLevel, this.root.assignVar(string, n2, n3));
    }

    private static VariantIndexer getVariantIndexer(VariantIndexer variantIndexer, Map<String, Integer> map) {
        if (map.isEmpty()) {
            if (variantIndexer != null) {
                return variantIndexer;
            }
            return new VariantIndexer(null, ArrayUtil.emptyStrings(), null);
        }
        int n = map.size();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        int n2 = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            stringArray[n2] = entry.getKey();
            nArray[n2] = entry.getValue();
            ++n2;
        }
        return new VariantIndexer(variantIndexer, stringArray, nArray);
    }

    VarAddress contextAddress(int n, int n2) {
        return n == this.scopeLevelCount ? new VarAddress(0, n2, null) : new VarAddress(4, this.scopeLevelCount - n - 1, n2, null);
    }

    VarAddress globalAddress(String string) {
        return new VarAddress(1, -1, string);
    }

    VarAddress constAddress(Object object) {
        return new VarAddress(2, -1, object);
    }

    public static class VarAddress {
        public static final int CONTEXT = 0;
        public static final int GLOBAL = 1;
        public static final int CONST = 2;
        public static final int SCOPE = 4;
        public final int type;
        public final int index;
        public final int scopeOffset;
        public final Object constValue;

        VarAddress(int n, int n2, int n3, Object object) {
            this.type = n;
            this.scopeOffset = n2;
            this.index = n3;
            this.constValue = object;
        }

        VarAddress(int n, int n2, Object object) {
            this(n, 0, n2, object);
        }
    }

    private class VarStair {
        final int scopeLevel;
        final int id;
        final int parentId;
        final Map<String, Integer> values;
        Map<String, Object> constMap;

        VarStair(int n, int n2) {
            this.id = n;
            this.parentId = n2;
            this.values = new HashMap<String, Integer>();
            this.scopeLevel = VariantManager.this.scopeLevelCount;
        }

        VarAddress locate(String string) {
            Integer n = this.values.get(string);
            if (n == null) {
                return null;
            }
            if (n < 0) {
                return VariantManager.this.constAddress(this.constMap.get(string));
            }
            return VariantManager.this.contextAddress(this.scopeLevel, n);
        }

        void checkDuplicate(String string, int n, int n2) {
            if (this.values.containsKey(string)) {
                throw new ParseException("Duplicate Variant declare: ".concat(string), n, n2);
            }
        }

        Integer assignVar(String string, int n, int n2) {
            this.checkDuplicate(string, n, n2);
            int n3 = VariantManager.this.varCount++;
            this.values.put(string, n3);
            return n3;
        }

        void assignConst(String string, Object object, int n, int n2) {
            this.checkDuplicate(string, n, n2);
            if (this.constMap == null) {
                this.constMap = new HashMap<String, Object>();
            }
            this.values.put(string, -1);
            this.constMap.put(string, object);
        }

        void assignVarsIfAbsent(String[] stringArray) {
            for (String string : stringArray) {
                if (this.values.containsKey(string)) continue;
                this.assignVar(string, -1, -1);
            }
        }
    }
}

