/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core;

import java.util.function.ObjIntConsumer;
import org.febit.wit.util.ArrayUtil;

public final class VariantIndexer {
    public static final VariantIndexer EMPTY = new VariantIndexer(null, ArrayUtil.emptyStrings(), null);
    private final VariantIndexer parent;
    private final String[] names;
    private final int[] indexs;

    VariantIndexer(VariantIndexer variantIndexer, String[] stringArray, int[] nArray) {
        this.parent = variantIndexer;
        this.names = stringArray;
        this.indexs = nArray;
    }

    public int getCurrentIndex(String string) {
        String[] stringArray = this.names;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return this.indexs[i];
        }
        return -1;
    }

    public void forEach(ObjIntConsumer<String> objIntConsumer) {
        String[] stringArray = this.names;
        int[] nArray = this.indexs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            objIntConsumer.accept(stringArray[i], nArray[i]);
        }
    }

    public int getIndex(String string) {
        int n = this.getCurrentIndex(string);
        if (n != -1) {
            return n;
        }
        if (this.parent != null) {
            return this.parent.getIndex(string);
        }
        return -1;
    }

    public String getName(int n) {
        return this.names[n];
    }
}

