/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.lang.method.MixedMultiNativeMethodDeclare;
import org.febit.wit.lang.method.MultiNativeConstructorDeclare;
import org.febit.wit.lang.method.MultiNativeMethodDeclare;
import org.febit.wit.lang.method.NativeConstructorDeclare;
import org.febit.wit.lang.method.NativeMethodDeclare;
import org.febit.wit.lang.method.NativeNewArrayDeclare;
import org.febit.wit.loggers.Logger;
import org.febit.wit.security.NativeSecurityManager;
import org.febit.wit.util.ClassUtil;

public class NativeFactory {
    protected final ConcurrentMap<Object, MethodDeclare> methodCaching = new ConcurrentHashMap<Object, MethodDeclare>();
    protected Logger logger;
    protected NativeSecurityManager nativeSecurityManager;

    public MethodDeclare getNativeNewArrayMethodDeclare(Class<?> clazz) {
        return this.getNativeNewArrayMethodDeclare(clazz, -1, -1, true);
    }

    public MethodDeclare getNativeNewArrayMethodDeclare(Class<?> clazz, boolean bl) {
        return this.getNativeNewArrayMethodDeclare(clazz, -1, -1, bl);
    }

    public MethodDeclare getNativeNewArrayMethodDeclare(Class<?> clazz, int n, int n2, boolean bl) {
        String string;
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        if (ClassUtil.isVoidType(clazz2)) {
            throw new ParseException("ComponentType must not void", n, n2);
        }
        if (bl && !this.nativeSecurityManager.access(string = clazz2.getName().concat(".[]"))) {
            throw NativeFactory.createNotAccessablePathException(string, n, n2);
        }
        return new NativeNewArrayDeclare(clazz);
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string) {
        return this.getNativeMethodDeclare(clazz, string, -1, -1, true);
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string, boolean bl) {
        return this.getNativeMethodDeclare(clazz, string, -1, -1, bl);
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string, Class[] classArray) {
        return this.getNativeMethodDeclare(clazz, string, classArray, -1, -1, true);
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string, Class[] classArray, boolean bl) {
        return this.getNativeMethodDeclare(clazz, string, classArray, -1, -1, bl);
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string, Class[] classArray, int n, int n2, boolean bl) {
        String string2;
        if (bl && !this.nativeSecurityManager.access(string2 = clazz.getName() + '.' + string)) {
            throw NativeFactory.createNotAccessablePathException(string2, n, n2);
        }
        try {
            return this.getNativeMethodDeclare(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ParseException(exception.getMessage(), (Throwable)exception, n, n2);
        }
    }

    public MethodDeclare getNativeMethodDeclare(Class<?> clazz, String string, int n, int n2, boolean bl) {
        String string2;
        if (bl && !this.nativeSecurityManager.access(string2 = clazz.getName() + '.' + string)) {
            throw NativeFactory.createNotAccessablePathException(string2, n, n2);
        }
        return this.createNativeMethodDeclare(clazz, string);
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz) {
        return this.getNativeConstructorDeclare(clazz, -1, -1, true);
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz, boolean bl) {
        return this.getNativeConstructorDeclare(clazz, -1, -1, bl);
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz, Class[] classArray) {
        return this.getNativeConstructorDeclare(clazz, classArray, -1, -1, true);
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz, Class[] classArray, boolean bl) {
        return this.getNativeConstructorDeclare(clazz, classArray, -1, -1, bl);
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz, Class[] classArray, int n, int n2, boolean bl) {
        String string;
        if (bl && !this.nativeSecurityManager.access(string = clazz.getName().concat(".<init>"))) {
            throw NativeFactory.createNotAccessablePathException(string, n, n2);
        }
        try {
            return this.getNativeConstructorDeclare(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ParseException(exception.getMessage(), (Throwable)exception, n, n2);
        }
    }

    public MethodDeclare getNativeConstructorDeclare(Class<?> clazz, int n, int n2, boolean bl) {
        String string;
        if (bl && !this.nativeSecurityManager.access(string = clazz.getName().concat(".<init>"))) {
            throw NativeFactory.createNotAccessablePathException(string, n, n2);
        }
        return this.createNativeConstructorDeclare(clazz);
    }

    public MethodDeclare getNativeMethodDeclare(Method method) {
        MethodDeclare methodDeclare;
        MethodDeclare methodDeclare2 = (MethodDeclare)this.methodCaching.get(method);
        if (methodDeclare2 == null && (methodDeclare = this.methodCaching.putIfAbsent(method, methodDeclare2 = this.createNativeMethodDeclare(method))) != null) {
            return methodDeclare;
        }
        return methodDeclare2;
    }

    public MethodDeclare getNativeConstructorDeclare(Constructor constructor) {
        MethodDeclare methodDeclare;
        MethodDeclare methodDeclare2 = (MethodDeclare)this.methodCaching.get(constructor);
        if (methodDeclare2 == null && (methodDeclare = this.methodCaching.putIfAbsent(constructor, methodDeclare2 = this.createNativeConstructorDeclare(constructor))) != null) {
            return methodDeclare;
        }
        return methodDeclare2;
    }

    public MethodDeclare createNativeConstructorDeclare(Class<?> clazz) {
        AccessibleObject[] accessibleObjectArray = clazz.getConstructors();
        if (accessibleObjectArray.length == 0) {
            throw new ScriptRuntimeException("Not found public constructor for class\uff1a " + clazz.getName());
        }
        if (accessibleObjectArray.length == 1) {
            return new NativeConstructorDeclare((Constructor)accessibleObjectArray[0]);
        }
        ClassUtil.setAccessible((AccessibleObject[])accessibleObjectArray);
        return new MultiNativeConstructorDeclare((Constructor[])accessibleObjectArray);
    }

    public MethodDeclare createNativeMethodDeclare(Class<?> clazz, String string) {
        Method[] methodArray = ClassUtil.getPublicMethods(clazz, string);
        if (methodArray.length == 0) {
            throw new ScriptRuntimeException("Method not found\uff1a " + clazz.getName() + '#' + string);
        }
        if (methodArray.length == 1) {
            return this.createNativeMethodDeclare(methodArray[0]);
        }
        return this.createMultiNativeMethodDeclare(methodArray);
    }

    public MethodDeclare createNativeMethodDeclare(Method method) {
        ClassUtil.setAccessible(method);
        return new NativeMethodDeclare(method);
    }

    public MethodDeclare createNativeMethodDeclare(List<Method> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("methods must mot empty");
        }
        int n = list.size();
        if (n == 1) {
            return this.createNativeMethodDeclare(list.get(0));
        }
        return this.createMultiNativeMethodDeclare(list.toArray(new Method[n]));
    }

    public MethodDeclare createMultiNativeMethodDeclare(Method[] methodArray) {
        if (methodArray == null || methodArray.length == 0) {
            throw new IllegalArgumentException("methods must mot empty");
        }
        ClassUtil.setAccessible((AccessibleObject[])methodArray);
        boolean bl = ClassUtil.isStatic(methodArray[0]);
        boolean bl2 = false;
        for (int i = 1; i < methodArray.length; ++i) {
            if (bl == ClassUtil.isStatic(methodArray[0])) continue;
            bl2 = true;
            break;
        }
        return bl2 ? new MixedMultiNativeMethodDeclare(methodArray) : new MultiNativeMethodDeclare(methodArray, bl);
    }

    protected MethodDeclare createNativeConstructorDeclare(Constructor constructor) {
        ClassUtil.setAccessible(constructor);
        return new NativeConstructorDeclare(constructor);
    }

    protected static ParseException createNotAccessablePathException(String string, int n, int n2) {
        return new ParseException("Not accessable of native path: ".concat(string), n, n2);
    }
}

