/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.febit.wit.Engine;
import org.febit.wit.Template;
import org.febit.wit.core.Lexer;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.NativeFactory;
import org.febit.wit.core.Parser;
import org.febit.wit.core.Symbol;
import org.febit.wit.core.VariantManager;
import org.febit.wit.core.ast.AssignableExpression;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.TemplateAST;
import org.febit.wit.core.ast.expressions.BreakPointExpression;
import org.febit.wit.core.ast.expressions.ContextScopeValue;
import org.febit.wit.core.ast.expressions.ContextValue;
import org.febit.wit.core.ast.expressions.DirectValue;
import org.febit.wit.core.ast.expressions.DynamicNativeMethodExecute;
import org.febit.wit.core.ast.expressions.GlobalValue;
import org.febit.wit.core.ast.expressions.MapValue;
import org.febit.wit.core.ast.expressions.MethodExecute;
import org.febit.wit.core.ast.expressions.NativeStaticValue;
import org.febit.wit.core.ast.operators.And;
import org.febit.wit.core.ast.operators.Assign;
import org.febit.wit.core.ast.operators.BiOperator;
import org.febit.wit.core.ast.operators.ConstableBiOperator;
import org.febit.wit.core.ast.operators.ConstableOperator;
import org.febit.wit.core.ast.operators.GroupAssign;
import org.febit.wit.core.ast.operators.IntStep;
import org.febit.wit.core.ast.operators.Or;
import org.febit.wit.core.ast.operators.SelfOperator;
import org.febit.wit.core.ast.statements.Block;
import org.febit.wit.core.ast.statements.BlockNoLoops;
import org.febit.wit.core.ast.statements.BreakPointStatement;
import org.febit.wit.core.ast.statements.IBlock;
import org.febit.wit.core.ast.statements.If;
import org.febit.wit.core.ast.statements.IfElse;
import org.febit.wit.core.ast.statements.IfNot;
import org.febit.wit.core.ast.statements.Interpolation;
import org.febit.wit.core.ast.statements.NoneStatement;
import org.febit.wit.core.ast.statements.StatementGroup;
import org.febit.wit.core.ast.statements.TryPart;
import org.febit.wit.core.text.TextStatementFactory;
import org.febit.wit.debug.BreakPointListener;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.exceptions.UncheckedException;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.loaders.Resource;
import org.febit.wit.loaders.ResourceOffset;
import org.febit.wit.security.NativeSecurityManager;
import org.febit.wit.util.ALU;
import org.febit.wit.util.ClassNameBand;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.ExceptionUtil;
import org.febit.wit.util.Stack;
import org.febit.wit.util.StatementUtil;
import org.febit.wit.util.StringUtil;

abstract class AbstractParser {
    static final int OP_PLUSEQ = 0;
    static final int OP_MINUSEQ = 1;
    static final int OP_MULTEQ = 2;
    static final int OP_DIVEQ = 3;
    static final int OP_MODEQ = 4;
    static final int OP_LSHIFTEQ = 5;
    static final int OP_RSHIFTEQ = 6;
    static final int OP_URSHIFTEQ = 7;
    static final int OP_ANDEQ = 8;
    static final int OP_XOREQ = 9;
    static final int OP_OREQ = 10;
    private static final short[][] PRODUCTION_TABLE = AbstractParser.loadData("Production");
    private static final short[][] ACTION_TABLE = AbstractParser.loadData("Action");
    private static final short[][] REDUCE_TABLE = AbstractParser.loadData("Reduce");
    private static final String[] SYMBOL_STRS = new String[]{"EOF", "ERROR", "var", "if", "else", "for", "this", "super", "switch", "case", "default", "do", "while", "throw", "try", "catch", "finally", "new", "instanceof", "function", "echo", "static", "native", "import", "include", "@import", "break", "continue", "return", "++", "--", "+", "-", "*", "/", "%", "<<", ">>", ">>>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "~", "&&", "||", "!", "?", "*=", "-", ".", ":", "::", ",", ";", "{", "}", "}", "(", ")", "[", "]", "[?", "?]", "[?]", "=>", ")->", "->", ".~", "..", "=", "`", "}", "${", "`", "IDENTIFIER", "::", "TEXT", "DIRECT_VALUE", "const", "UNKNOWN"};
    private final Map<String, String> importedClasses = new HashMap<String, String>();
    private final Map<String, Integer> labelIndexMap = new HashMap<String, Integer>();
    private final AtomicInteger nextLabelIndex = new AtomicInteger();
    private TextStatementFactory textStatementFactory;
    private NativeSecurityManager nativeSecurityManager;
    private BreakPointListener breakPointListener;
    private Engine engine;
    private NativeFactory nativeFactory;
    private boolean locateVarForce;
    protected final Stack<Symbol> symbolStack = new Stack(24);
    protected Template template;
    protected VariantManager varmgr;
    protected boolean goonParse;

    AbstractParser() {
    }

    private static short getAction(short[] sArray, int n) {
        int n2 = sArray.length;
        if (n2 < 20) {
            for (int i = 0; i < n2; ++i) {
                if (sArray[i++] != n) continue;
                return sArray[i];
            }
        } else {
            int n3 = 0;
            int n4 = n2 - 1 >> 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >> 1;
                int n6 = n5 << 1;
                if (n == sArray[n6]) {
                    return sArray[n6 + 1];
                }
                if (n > sArray[n6]) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5 - 1;
            }
        }
        return 0;
    }

    private static short getReduce(short[] sArray, int n) {
        if (sArray != null) {
            int n2 = sArray.length;
            for (int i = 0; i < n2; ++i) {
                if (sArray[i++] != n) continue;
                return sArray[i];
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static short[][] loadData(String string) {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(ClassUtil.getDefaultClassLoader().getResourceAsStream("org/febit/wit/core/Parser$" + string + ".data"));){
            short[][] sArray = (short[][])objectInputStream.readObject();
            return sArray;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new UncheckedException(exception);
        }
    }

    private static String getSimpleHintMessage(Symbol symbol) {
        boolean bl;
        short[] sArray = ACTION_TABLE[symbol.state];
        int n = sArray.length;
        if (n == 0) {
            return "[no hints]";
        }
        boolean bl2 = bl = n > 8;
        if (bl && AbstractParser.getAction(sArray, 59) != 0) {
            return "forget ';' ?";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        for (int i = 0; i < n; i += 2) {
            short s = sArray[i];
            if (bl && !AbstractParser.isHintLevelOne(s)) continue;
            if (bl3) {
                stringBuilder.append(", ");
            } else {
                bl3 = true;
            }
            stringBuilder.append('\'').append(AbstractParser.symbolToString(s)).append('\'');
        }
        return stringBuilder.toString();
    }

    private static boolean isHintLevelOne(short s) {
        switch (s) {
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 80: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    private static String symbolToString(short s) {
        if (s >= 0 && s < SYMBOL_STRS.length) {
            return SYMBOL_STRS[s];
        }
        return "UNKNOWN";
    }

    public static TemplateAST parse(Template template, BreakPointListener breakPointListener) throws ParseException {
        return new Parser().doParse(template, breakPointListener);
    }

    public static TemplateAST parse(Template template) throws ParseException {
        return AbstractParser.parse(template, null);
    }

    abstract Object doAction(int var1) throws ParseException;

    private Symbol process(Lexer lexer) throws IOException {
        Stack<Symbol> stack = this.symbolStack;
        stack.clear();
        Symbol symbol = new Symbol(0, -1, -1, null);
        symbol.state = 0;
        stack.push(symbol);
        short[][] sArray = ACTION_TABLE;
        short[][] sArray2 = REDUCE_TABLE;
        short[][] sArray3 = PRODUCTION_TABLE;
        boolean bl = this.engine.isLooseSemicolon();
        Symbol symbol2 = null;
        Symbol symbol3 = lexer.nextToken();
        this.goonParse = true;
        do {
            int n;
            if ((n = AbstractParser.getAction(sArray[symbol.state], symbol3.id)) > 0) {
                symbol3.state = n - 1;
                stack.push(symbol3);
                symbol = symbol3;
                if (symbol2 != null) {
                    symbol3 = symbol2;
                    symbol2 = null;
                } else {
                    symbol3 = lexer.nextToken();
                    if (bl && symbol.isOnEdgeOfNewLine) {
                        switch (symbol3.id) {
                            case 65: {
                                if (symbol.id == 58 || symbol.id == 60) break;
                            }
                            case 29: 
                            case 30: 
                            case 60: 
                            case 63: {
                                symbol2 = symbol3;
                                symbol3 = this.createLooseSemicolonSymbol(symbol2);
                                break;
                            }
                        }
                    }
                }
                if (!bl || symbol2 != null || !symbol3.isOnEdgeOfNewLine) continue;
                switch (symbol3.id) {
                    case 26: 
                    case 27: 
                    case 28: {
                        symbol2 = this.createLooseSemicolonSymbol(symbol3);
                        break;
                    }
                }
                continue;
            }
            if (n == 0 && bl && symbol3.id != 59 && (symbol.isOnEdgeOfNewLine || symbol3.id == 61) && (n = (int)AbstractParser.getAction(sArray[symbol.state], 59)) != 0) {
                symbol2 = symbol3;
                symbol3 = this.createLooseSemicolonSymbol(symbol2);
                if (n > 0) continue;
            }
            if (n == 0) {
                throw new ParseException(StringUtil.format("Syntax error at line {} column {}, Hints: {}", lexer.getLine(), lexer.getColumn(), AbstractParser.getSimpleHintMessage(symbol)), lexer.getLine(), lexer.getColumn());
            }
            boolean bl2 = symbol.isOnEdgeOfNewLine;
            n = -n - 1;
            Object object = this.doAction(n);
            short[] sArray4 = sArray3[n];
            short s = sArray4[0];
            short s2 = sArray4[1];
            if (s2 == 0) {
                symbol = new Symbol(s, -1, -1, object);
            } else {
                symbol = new Symbol(s, object, stack.peek(s2 - 1));
                stack.pops(s2);
            }
            symbol.state = AbstractParser.getReduce(sArray2[stack.peek().state], s);
            symbol.isOnEdgeOfNewLine = bl2;
            stack.push(symbol);
        } while (this.goonParse);
        return stack.peek();
    }

    private Symbol createLooseSemicolonSymbol(Symbol symbol) {
        return new Symbol(59, symbol.line, symbol.column, null);
    }

    protected TemplateAST doParse(Template template, BreakPointListener breakPointListener) throws ParseException {
        Engine engine = template.getEngine();
        Resource resource = template.getResource();
        this.textStatementFactory = engine.get(TextStatementFactory.class);
        this.nativeSecurityManager = engine.get(NativeSecurityManager.class);
        this.breakPointListener = breakPointListener;
        this.template = template;
        this.engine = engine;
        this.locateVarForce = !engine.isLooseVar();
        this.nativeFactory = engine.getNativeFactory();
        this.varmgr = new VariantManager(engine);
        this.labelIndexMap.put(null, 0);
        this.nextLabelIndex.set(1);
        Lexer lexer = null;
        try {
            lexer = new Lexer(resource.openReader());
            lexer.setTrimCodeBlockBlankLine(engine.isTrimCodeBlockBlankLine());
            if (resource.isCodeFirst()) {
                lexer.codeFirst();
            }
            if (resource instanceof ResourceOffset) {
                lexer.setOffset((ResourceOffset)((Object)resource));
            } else {
                lexer.setOffset(0, 0);
            }
            this.textStatementFactory.startTemplateParser(template);
            TemplateAST templateAST = (TemplateAST)this.process((Lexer)lexer).value;
            return templateAST;
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        finally {
            this.textStatementFactory.finishTemplateParser(template);
            if (lexer != null) {
                try {
                    lexer.close();
                }
                catch (IOException iOException) {
                    this.engine.getLogger().warn("Failed to close lexer.", iOException);
                }
            }
        }
    }

    boolean registClass(ClassNameBand classNameBand, int n, int n2) throws ParseException {
        String string = classNameBand.getClassSimpleName();
        if (ClassUtil.getPrimitiveClass(string) != null) {
            throw new ParseException("Duplicate class simple name:".concat(classNameBand.getClassPureName()), n, n2);
        }
        if (this.importedClasses.containsKey(string)) {
            throw new ParseException("Duplicate class register:".concat(classNameBand.getClassPureName()), n, n2);
        }
        this.importedClasses.put(string, classNameBand.getClassPureName());
        return true;
    }

    Class<?> toClass(String string) {
        int n = 0;
        int n2 = string.indexOf(91);
        if (n2 >= 0) {
            for (Object object : (String)string.substring(n2).toCharArray()) {
                if (object != 91) continue;
                ++n;
            }
            string = string.substring(0, n2).trim();
        }
        String string2 = this.resolveClassFullName(string);
        try {
            return ClassUtil.getClass(string2, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Class<?> not found:".concat(string2), classNotFoundException);
        }
    }

    String resolveClassFullName(String string) {
        if (string.indexOf(46) >= 0) {
            return string;
        }
        String string2 = this.importedClasses.get(string);
        if (string2 != null) {
            return string2;
        }
        Class<?> clazz = ClassUtil.getPrimitiveClass(string);
        if (clazz != null) {
            return string;
        }
        try {
            clazz = ClassUtil.getClass("java.lang.".concat(string));
        }
        catch (Exception exception) {
            ExceptionUtil.ignore(exception);
        }
        if (clazz != null) {
            return clazz.getName();
        }
        return string;
    }

    Class<?> toClass(ClassNameBand classNameBand, int n, int n2) throws ParseException {
        String string = this.resolveClassFullName(classNameBand.getClassPureName());
        try {
            return ClassUtil.getClass(string, classNameBand.getArrayDepth());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Class<?> not found:".concat(string), (Throwable)classNotFoundException, n, n2);
        }
    }

    int getLabelIndex(String string) {
        Integer n = this.labelIndexMap.get(string);
        if (n == null) {
            n = this.nextLabelIndex.getAndIncrement();
            this.labelIndexMap.put(string, n);
        }
        return n;
    }

    Expression createAssign(AssignableExpression assignableExpression, Expression expression, int n, int n2) {
        return new Assign(assignableExpression, expression, n, n2);
    }

    Expression createGroupAssign(Expression[] expressionArray, Expression expression, int n, int n2) {
        AssignableExpression[] assignableExpressionArray = new AssignableExpression[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            assignableExpressionArray[i] = this.castToAssignableExpression(expressionArray[i]);
        }
        return new GroupAssign(assignableExpressionArray, expression, n, n2);
    }

    Expression createBreakPointExpression(Expression expression, Expression expression2, int n, int n2) {
        Object object;
        Object object2 = object = expression == null ? null : StatementUtil.calcConst(expression);
        if (this.breakPointListener == null) {
            return expression2;
        }
        return new BreakPointExpression(this.breakPointListener, object, expression2, n, n2);
    }

    Statement createBreakPointStatement(Expression expression, Statement statement, int n, int n2) {
        Object object;
        Object object2 = object = expression == null ? null : StatementUtil.calcConst(expression);
        if (this.breakPointListener == null) {
            return statement;
        }
        return new BreakPointStatement(this.breakPointListener, object, statement, n, n2);
    }

    Statement createTextStatement(char[] cArray, int n, int n2) {
        if (cArray == null || cArray.length == 0) {
            return NoneStatement.INSTANCE;
        }
        return this.textStatementFactory.getTextStatement(this.template, cArray, n, n2);
    }

    ContextValue declearVarAndCreateContextValue(String string, int n, int n2) {
        return new ContextValue(this.varmgr.assignVariant(string, n, n2), n, n2);
    }

    ContextValue[] declearVarAndCreateContextValues(List<String> list, int n, int n2) {
        ContextValue[] contextValueArray = new ContextValue[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            contextValueArray[i] = this.declearVarAndCreateContextValue(list.get(i), n, n2);
        }
        return contextValueArray;
    }

    MapValue createMapValue(List<Expression[]> list, int n, int n2) {
        if (list == null || list.isEmpty()) {
            return new MapValue(StatementUtil.emptyExpressions(), StatementUtil.emptyExpressions(), n, n2);
        }
        int n3 = list.size();
        Expression[] expressionArray = new Expression[n3];
        Expression[] expressionArray2 = new Expression[n3];
        for (int i = 0; i < list.size(); ++i) {
            Expression[] expressionArray3 = list.get(i);
            expressionArray[i] = expressionArray3[0];
            expressionArray2[i] = expressionArray3[1];
        }
        return new MapValue(expressionArray, expressionArray2, n, n2);
    }

    DirectValue createDirectValue(Symbol symbol) {
        return new DirectValue(symbol.value, symbol.line, symbol.column);
    }

    Expression createContextValue(VariantManager.VarAddress varAddress, int n, int n2) {
        switch (varAddress.type) {
            case 1: {
                return new GlobalValue(this.engine.getGlobalManager(), varAddress.constValue.toString(), n, n2);
            }
            case 2: {
                return new DirectValue(varAddress.constValue, n, n2);
            }
            case 4: {
                return new ContextScopeValue(varAddress.scopeOffset, varAddress.index, n, n2);
            }
        }
        return new ContextValue(varAddress.index, n, n2);
    }

    Expression createContextValueAtUpstair(int n, String string, int n2, int n3) {
        return this.createContextValue(this.varmgr.locateAtUpstair(string, n, n2, n3), n2, n3);
    }

    Expression createContextValue(int n, String string, int n2, int n3) {
        return this.createContextValue(this.varmgr.locate(string, n, this.locateVarForce, n2, n3), n2, n3);
    }

    void assignConst(String string, Expression expression, int n, int n2) {
        this.varmgr.assignConst(string, StatementUtil.calcConst(expression), n, n2);
    }

    Expression createNativeStaticValue(ClassNameBand classNameBand, int n, int n2) {
        Field field;
        if (classNameBand.size() < 2) {
            throw new ParseException("native static need a field name.", n, n2);
        }
        String string = classNameBand.pop();
        Class<?> clazz = this.toClass(classNameBand, n, n2);
        String string2 = clazz.getName() + '.' + string;
        if (!this.nativeSecurityManager.access(string2)) {
            throw new ParseException("Not accessable of native path: ".concat(string2), n, n2);
        }
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ParseException("No such field: ".concat(string2), (Throwable)noSuchFieldException, n, n2);
        }
        if (ClassUtil.isStatic(field)) {
            ClassUtil.setAccessible(field);
            if (ClassUtil.isFinal(field)) {
                try {
                    return new DirectValue(field.get(null), n, n2);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    throw new ParseException("Failed to get static field value: ".concat(string2), (Throwable)exception, n, n2);
                }
            }
            return new NativeStaticValue(field, n, n2);
        }
        throw new ParseException("No a static field: ".concat(string2), n, n2);
    }

    Statement createInterpolation(Expression expression) {
        return new Interpolation(expression);
    }

    Expression createNativeNewArrayDeclareExpression(Class<?> clazz, int n, int n2) {
        return new DirectValue(this.nativeFactory.getNativeNewArrayMethodDeclare(clazz, n, n2, true), n, n2);
    }

    Expression createNativeMethodDeclareExpression(Class<?> clazz, String string, List<Class> list, int n, int n2) {
        return new DirectValue(this.nativeFactory.getNativeMethodDeclare(clazz, string, list == null ? new Class[]{} : list.toArray(new Class[list.size()]), n, n2, true), n, n2);
    }

    Expression createMethodReference(String string, int n, int n2) {
        int n3 = string.indexOf("::");
        String string2 = string.substring(0, n3).trim();
        String string3 = string.substring(n3 + 2).trim();
        Class<?> clazz = this.toClass(string2);
        MethodDeclare methodDeclare = "new".equals(string3) ? (clazz.isArray() ? this.nativeFactory.getNativeNewArrayMethodDeclare(clazz.getComponentType(), n, n2, true) : this.nativeFactory.getNativeConstructorDeclare(clazz, n, n2, true)) : this.nativeFactory.getNativeMethodDeclare(clazz, string3, n, n2, true);
        return new DirectValue(methodDeclare, n, n2);
    }

    Expression createNativeConstructorDeclareExpression(Class<?> clazz, List<Class> list, int n, int n2) {
        return new DirectValue(this.nativeFactory.getNativeConstructorDeclare(clazz, list == null ? new Class[]{} : list.toArray(new Class[list.size()]), n, n2, true), n, n2);
    }

    Statement declearVar(String string, int n, int n2) {
        this.varmgr.assignVariant(string, n, n2);
        return NoneStatement.INSTANCE;
    }

    Statement createIfStatement(Expression expression, Statement statement, Statement statement2, int n, int n2) {
        statement = StatementUtil.optimize(statement);
        statement2 = StatementUtil.optimize(statement2);
        if (statement != null) {
            if (statement2 != null) {
                return new IfElse(expression, statement, statement2, n, n2);
            }
            return new If(expression, statement, n, n2);
        }
        if (statement2 != null) {
            return new IfNot(expression, statement2, n, n2);
        }
        return NoneStatement.INSTANCE;
    }

    Statement createStatementGroup(List<Statement> list, int n, int n2) {
        return new StatementGroup(StatementUtil.toStatementArray(list), n, n2);
    }

    Expression createMethodExecute(Expression expression, Expression[] expressionArray, int n, int n2) {
        StatementUtil.optimize(expressionArray);
        expression = StatementUtil.optimize(expression);
        return new MethodExecute(expression, expressionArray, n, n2);
    }

    Expression createDynamicNativeMethodExecute(Expression expression, String string, Expression[] expressionArray, int n, int n2) {
        StatementUtil.optimize(expressionArray);
        expression = StatementUtil.optimize(expression);
        return new DynamicNativeMethodExecute(expression, string, expressionArray, n, n2);
    }

    TemplateAST createTemplateAST(List<Statement> list) {
        Statement[] statementArray = StatementUtil.toStatementArray(list);
        List<LoopInfo> list2 = StatementUtil.collectPossibleLoops(statementArray);
        if (!list2.isEmpty()) {
            throw new ParseException("loop overflow: " + StringUtil.join(list2, ','));
        }
        return new TemplateAST(this.varmgr.getIndexers(), statementArray, this.varmgr.getVarCount());
    }

    IBlock createIBlock(List<Statement> list, int n, int n2, int n3) {
        Statement[] statementArray = StatementUtil.toStatementArray(list);
        List<LoopInfo> list2 = StatementUtil.collectPossibleLoops(statementArray);
        return list2.isEmpty() ? new BlockNoLoops(n, statementArray, n2, n3) : new Block(n, statementArray, list2.toArray(new LoopInfo[list2.size()]), n2, n3);
    }

    TryPart createTryPart(List<Statement> list, int n, int n2, int n3) {
        return new TryPart(this.createIBlock(list, n, n2, n3), n2, n3);
    }

    AssignableExpression castToAssignableExpression(Expression expression) {
        if (expression instanceof AssignableExpression) {
            return (AssignableExpression)expression;
        }
        throw new ParseException("expression is not assignable", (Statement)expression);
    }

    Expression createSelfOperator(Expression expression, int n, Expression expression2, int n2, int n3) {
        AssignableExpression assignableExpression = this.castToAssignableExpression(expression);
        BiFunction<Object, Object, Object> biFunction = this.getBiFunctionForBiOperator(n);
        if (biFunction == null) {
            throw new ParseException("Unsupported Operator", n2, n3);
        }
        return StatementUtil.optimize(new SelfOperator(assignableExpression, expression2, biFunction, n2, n3));
    }

    BiFunction<Object, Object, Object> getBiFunctionForBiOperator(int n) {
        switch (n) {
            case 0: 
            case 31: {
                return ALU::plus;
            }
            case 1: 
            case 32: {
                return ALU::minus;
            }
            case 2: 
            case 33: {
                return ALU::mult;
            }
            case 3: 
            case 34: {
                return ALU::div;
            }
            case 4: 
            case 35: {
                return ALU::mod;
            }
            case 5: 
            case 36: {
                return ALU::lshift;
            }
            case 6: 
            case 37: {
                return ALU::rshift;
            }
            case 7: 
            case 38: {
                return ALU::urshift;
            }
            case 39: {
                return ALU::less;
            }
            case 40: {
                return ALU::greater;
            }
            case 41: {
                return ALU::lessEqual;
            }
            case 42: {
                return ALU::greaterEqual;
            }
            case 43: {
                return ALU::isEqual;
            }
            case 44: {
                return ALU::notEqual;
            }
            case 8: 
            case 45: {
                return ALU::bitAnd;
            }
            case 9: 
            case 46: {
                return ALU::bitXor;
            }
            case 10: 
            case 47: {
                return ALU::bitOr;
            }
        }
        return null;
    }

    Expression createOperator(Expression expression, Symbol symbol) {
        Function<Object, Object> function;
        int n = symbol.line;
        int n2 = symbol.column;
        switch ((Integer)symbol.value) {
            case 48: {
                function = ALU::bitNot;
                break;
            }
            case 32: {
                function = ALU::negative;
                break;
            }
            case 51: {
                function = ALU::not;
                break;
            }
            default: {
                throw new ParseException("Unsupported Operator", n, n2);
            }
        }
        return StatementUtil.optimize(new ConstableOperator(expression, function, n, n2));
    }

    Expression createBiOperator(Expression expression, Symbol symbol, Expression expression2) {
        BiOperator biOperator;
        int n = symbol.line;
        int n2 = symbol.column;
        switch ((Integer)symbol.value) {
            case 49: {
                biOperator = new And(expression, expression2, n, n2);
                break;
            }
            case 50: {
                biOperator = new Or(expression, expression2, n, n2);
                break;
            }
            case 74: {
                biOperator = new IntStep(expression, expression2, n, n2);
                break;
            }
            default: {
                BiFunction<Object, Object, Object> biFunction = this.getBiFunctionForBiOperator((Integer)symbol.value);
                if (biFunction == null) {
                    throw new ParseException("Unsupported Operator", n, n2);
                }
                biOperator = new ConstableBiOperator(expression, expression2, biFunction, n, n2);
            }
        }
        return StatementUtil.optimize(biOperator);
    }
}

