/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.febit.wit.asm.ASMUtil;
import org.febit.wit.asm.AsmResolver;
import org.febit.wit.exceptions.UncheckedException;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.ResolverManager;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.util.ClassMap;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.StringUtil;
import org.febit.wit.util.bean.FieldInfo;
import org.febit.wit.util.bean.FieldInfoResolver;
import org.febit.wit_shaded.asm.ClassWriter;
import org.febit.wit_shaded.asm.Label;
import org.febit.wit_shaded.asm.MethodWriter;

public class AsmResolverManager
extends ResolverManager {
    private static final String[] ASM_RESOLVER = new String[]{"org/febit/wit/asm/AsmResolver"};
    private static final ClassMap<AsmResolver> CACHE = new ClassMap();

    @Override
    protected SetResolver resolveSetResolver(Class<?> clazz) {
        AsmResolver asmResolver = this.getAsmResolver(clazz);
        if (asmResolver != null) {
            return asmResolver;
        }
        return super.resolveSetResolver(clazz);
    }

    @Override
    protected GetResolver resolveGetResolver(Class<?> clazz) {
        AsmResolver asmResolver = this.getAsmResolver(clazz);
        if (asmResolver != null) {
            return asmResolver;
        }
        return super.resolveGetResolver(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsmResolver getAsmResolver(Class<?> clazz) {
        AsmResolver asmResolver = CACHE.get(clazz);
        if (asmResolver == null) {
            ClassMap<AsmResolver> classMap = CACHE;
            synchronized (classMap) {
                asmResolver = CACHE.get(clazz);
                if (asmResolver == null) {
                    try {
                        asmResolver = (AsmResolver)AsmResolverManager.createResolverClass(clazz).newInstance();
                        asmResolver = CACHE.putIfAbsent(clazz, asmResolver);
                    }
                    catch (Exception | LinkageError throwable) {
                        this.logger.error("Failed to create resolver for:".concat(clazz.getName()), throwable);
                    }
                }
            }
        }
        return asmResolver;
    }

    static Class<?> createResolverClass(Class<?> clazz) {
        int[] nArray;
        int[] nArray2;
        if (!ClassUtil.isPublic(clazz)) {
            throw new UncheckedException(StringUtil.format("Class<?> [{}] is not public", clazz));
        }
        String string = "org.febit.wit.asm.Resolver" + ASMUtil.NEXT_SN.getAndIncrement();
        ClassWriter classWriter = new ClassWriter(49, 17, ASMUtil.getInternalName(string), "java/lang/Object", ASM_RESOLVER);
        ASMUtil.visitConstructor(classWriter);
        Object[] objectArray = (FieldInfo[])FieldInfoResolver.resolve(clazz).sorted().toArray(FieldInfo[]::new);
        Arrays.sort(objectArray);
        int n = objectArray.length;
        if (n > 0) {
            int n2;
            nArray2 = new int[n];
            nArray = new int[n];
            int n3 = 0;
            nArray2[n3++] = n2 = ((FieldInfo)objectArray[0]).hashOfName;
            for (int i = 1; i < n; ++i) {
                Object object = objectArray[i];
                if (n2 == ((FieldInfo)object).hashOfName) continue;
                nArray[n3 - 1] = i;
                nArray2[n3++] = n2 = ((FieldInfo)object).hashOfName;
            }
            nArray[n3 - 1] = n;
            nArray2 = Arrays.copyOf(nArray2, n3);
            nArray = Arrays.copyOf(nArray, n3);
        } else {
            nArray2 = null;
            nArray = null;
        }
        AsmResolverManager.visitXetMethod(true, classWriter, clazz, (FieldInfo[])objectArray, nArray2, nArray);
        AsmResolverManager.visitXetMethod(false, classWriter, clazz, (FieldInfo[])objectArray, nArray2, nArray);
        MethodWriter methodWriter = classWriter.visitMethod(1, "getMatchClass", "()Ljava/lang/Class;", null);
        methodWriter.visitInsn(1);
        methodWriter.visitInsn(176);
        methodWriter.visitMaxs();
        return ASMUtil.loadClass(string, classWriter);
    }

    private static void visitXetMethod(boolean bl, ClassWriter classWriter, Class<?> clazz, FieldInfo[] fieldInfoArray, int[] nArray, int[] nArray2) {
        String string = ASMUtil.getBoxedInternalName(clazz);
        MethodWriter methodWriter = bl ? classWriter.visitMethod(1, "get", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null) : classWriter.visitMethod(1, "set", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", null);
        int n = fieldInfoArray.length;
        if (n != 0) {
            Label label = new Label();
            if (n < 4) {
                AsmResolverManager.visitXetFields(bl, methodWriter, fieldInfoArray, 0, n, string, label);
            } else {
                int n2;
                methodWriter.visitVarInsn(25, 2);
                methodWriter.invokeVirtual("java/lang/Object", "hashCode", "()I");
                int n3 = nArray.length;
                Label[] labelArray = new Label[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    labelArray[n2] = new Label();
                }
                methodWriter.visitLookupSwitchInsn(label, nArray, labelArray);
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray2[i];
                    methodWriter.visitLabel(labelArray[i]);
                    AsmResolverManager.visitXetFields(bl, methodWriter, fieldInfoArray, n2, n4, string, label);
                    n2 = n4;
                }
            }
            methodWriter.visitLabel(label);
        }
        methodWriter.visitTypeInsn(187, "org/febit/wit/exceptions/ScriptRuntimeException");
        methodWriter.visitInsn(89);
        methodWriter.visitLdcInsn("Invalid property " + clazz.getName() + '#');
        methodWriter.visitVarInsn(25, 2);
        methodWriter.invokeStatic("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
        methodWriter.invokeVirtual("java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        methodWriter.visitMethodInsn(183, "org/febit/wit/exceptions/ScriptRuntimeException", "<init>", "(Ljava/lang/String;)V");
        methodWriter.visitInsn(191);
        methodWriter.visitMaxs();
    }

    private static void visitXetFields(boolean bl, MethodWriter methodWriter, FieldInfo[] fieldInfoArray, int n, int n2, String string, Label label) {
        Object object;
        int n3;
        Label[] labelArray = new Label[n2 - n];
        for (n3 = n; n3 < n2; ++n3) {
            object = new Label();
            labelArray[n3 - n] = object;
            methodWriter.visitLdcInsn(fieldInfoArray[n3].name);
            methodWriter.visitVarInsn(25, 2);
            methodWriter.visitJumpInsn(165, (Label)object);
        }
        for (n3 = n; n3 < n2; ++n3) {
            methodWriter.visitLdcInsn(fieldInfoArray[n3].name);
            methodWriter.visitVarInsn(25, 2);
            methodWriter.invokeVirtual("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            methodWriter.visitJumpInsn(154, labelArray[n3 - n]);
        }
        methodWriter.visitJumpInsn(167, label);
        for (n3 = n; n3 < n2; ++n3) {
            methodWriter.visitLabel(labelArray[n3 - n]);
            object = fieldInfoArray[n3];
            if (bl) {
                AsmResolverManager.appendGetFieldCode(methodWriter, (FieldInfo)object, string);
                continue;
            }
            AsmResolverManager.appendSetFieldCode(methodWriter, (FieldInfo)object, string);
        }
    }

    private static void appendGetFieldCode(MethodWriter methodWriter, FieldInfo fieldInfo, String string) {
        Method method = fieldInfo.getGetterMethod();
        Field field = fieldInfo.getField();
        if (method != null || field != null) {
            Class<?> clazz = method != null ? method.getReturnType() : field.getType();
            methodWriter.visitVarInsn(25, 1);
            methodWriter.checkCast(string);
            if (method != null) {
                methodWriter.invokeVirtual(string, method.getName(), ASMUtil.getDescriptor(method));
            } else {
                methodWriter.visitFieldInsn(180, string, fieldInfo.name, ASMUtil.getDescriptor(clazz));
            }
            ASMUtil.visitBoxIfNeed(methodWriter, clazz);
            methodWriter.visitInsn(176);
        } else {
            ASMUtil.visitScriptRuntimeException(methodWriter, StringUtil.format("Unreadable property {}#{}", fieldInfo.owner.getName(), fieldInfo.name));
        }
    }

    private static void appendSetFieldCode(MethodWriter methodWriter, FieldInfo fieldInfo, String string) {
        Method method = fieldInfo.getSetterMethod();
        if (method != null || fieldInfo.isFieldSettable()) {
            Class<?> clazz = method != null ? method.getParameterTypes()[0] : fieldInfo.getField().getType();
            methodWriter.visitVarInsn(25, 1);
            methodWriter.checkCast(string);
            methodWriter.visitVarInsn(25, 3);
            methodWriter.checkCast(ASMUtil.getBoxedInternalName(clazz));
            ASMUtil.visitUnboxIfNeed(methodWriter, clazz);
            if (method != null) {
                methodWriter.invokeVirtual(string, method.getName(), ASMUtil.getDescriptor(method));
            } else {
                methodWriter.visitFieldInsn(181, string, fieldInfo.name, ASMUtil.getDescriptor(clazz));
            }
            methodWriter.visitInsn(177);
        } else {
            ASMUtil.visitScriptRuntimeException(methodWriter, StringUtil.format("Unwriteable property {}#{}", fieldInfo.owner.getName(), fieldInfo.name));
        }
    }
}

