/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.febit.wit.util.ClassUtil;
import org.febit.wit_shaded.asm.ClassWriter;
import org.febit.wit_shaded.asm.MethodWriter;

class ASMUtil {
    static final String TYPE_STRING_NAME = "java/lang/String";
    static final String METHOD_CTOR = "<init>";
    static final AtomicInteger NEXT_SN = new AtomicInteger(1);
    private static final AsmClassLoader CLASS_LOADER = new AsmClassLoader();

    private ASMUtil() {
    }

    static Class<?> loadClass(String string, ClassWriter classWriter) {
        return CLASS_LOADER.loadClass(string, classWriter.toByteArray());
    }

    static String getBoxedInternalName(Class<?> clazz) {
        return ASMUtil.getInternalName(clazz.isPrimitive() ? ClassUtil.getBoxedPrimitiveClass(clazz).getName() : clazz.getName());
    }

    static String getInternalName(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] == '.') {
                cArray[n] = 47;
            }
            ++n;
        }
        return new String(cArray);
    }

    static String getDescriptor(Constructor constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : constructor.getParameterTypes()) {
            stringBuilder.append(ASMUtil.getDescriptor(clazz));
        }
        return stringBuilder.append(")V").toString();
    }

    static String getDescriptor(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(ASMUtil.getDescriptor(clazz));
        }
        return stringBuilder.append(')').append(ASMUtil.getDescriptor(method.getReturnType())).toString();
    }

    static String getDescriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return String.valueOf(ClassUtil.getAliasOfBaseType(clazz.getName()));
        }
        String string = ASMUtil.getInternalName(clazz.getName());
        if (clazz.isArray()) {
            return string;
        }
        return new StringBuffer(string.length() + 2).append('L').append(string).append(';').toString();
    }

    static void visitBoxIfNeed(MethodWriter methodWriter, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        if (clazz == Void.TYPE) {
            methodWriter.visitFieldInsn(178, "org/febit/wit/Context", "VOID", "Ljava/lang/Object;");
            return;
        }
        String string = ASMUtil.getBoxedInternalName(clazz);
        methodWriter.invokeStatic(string, "valueOf", "(" + ASMUtil.getDescriptor(clazz) + ")L" + string + ";");
    }

    static void visitUnboxIfNeed(MethodWriter methodWriter, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        if (clazz == Void.TYPE) {
            return;
        }
        methodWriter.invokeVirtual(ASMUtil.getBoxedInternalName(clazz), clazz.getName() + "Value", "()" + ASMUtil.getDescriptor(clazz));
    }

    static void visitScriptRuntimeException(MethodWriter methodWriter, String string) {
        methodWriter.visitTypeInsn(187, "org/febit/wit/exceptions/ScriptRuntimeException");
        methodWriter.visitInsn(89);
        methodWriter.visitLdcInsn(string);
        methodWriter.visitMethodInsn(183, "org/febit/wit/exceptions/ScriptRuntimeException", METHOD_CTOR, "(Ljava/lang/String;)V");
        methodWriter.visitInsn(191);
    }

    static void visitConstructor(ClassWriter classWriter) {
        MethodWriter methodWriter = classWriter.visitMethod(1, METHOD_CTOR, "()V", null);
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitMethodInsn(183, "java/lang/Object", METHOD_CTOR, "()V");
        methodWriter.visitInsn(177);
        methodWriter.visitMaxs();
    }

    private static final class AsmClassLoader
    extends ClassLoader {
        AsmClassLoader() {
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            return ClassUtil.getDefaultClassLoader().loadClass(string);
        }

        Class<?> loadClass(String string, byte[] byArray) throws ClassFormatError {
            return this.defineClass(string, byArray, 0, byArray.length, null);
        }
    }
}

